/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.v8dtoa;

import org.mozilla.javascript.v8dtoa.DiyFp;

public class DoubleHelper {
    static final long kSignMask = Long.MIN_VALUE;
    static final long kExponentMask = 0x7FF0000000000000L;
    static final long kSignificandMask = 0xFFFFFFFFFFFFFL;
    static final long kHiddenBit = 0x10000000000000L;
    private static final int kSignificandSize = 52;
    private static final int kExponentBias = 1075;
    private static final int kDenormalExponent = -1074;

    static DiyFp asDiyFp(long l) {
        assert (!DoubleHelper.isSpecial(l));
        return new DiyFp(DoubleHelper.significand(l), DoubleHelper.exponent(l));
    }

    static DiyFp asNormalizedDiyFp(long l) {
        long l2 = DoubleHelper.significand(l);
        int n = DoubleHelper.exponent(l);
        assert (l2 != 0L);
        while ((l2 & 0x10000000000000L) == 0L) {
            l2 <<= 1;
            --n;
        }
        return new DiyFp(l2 <<= 11, n -= 11);
    }

    static int exponent(long l) {
        if (DoubleHelper.isDenormal(l)) {
            return -1074;
        }
        int n = (int)((l & 0x7FF0000000000000L) >>> 52 & 0xFFFFFFFFL);
        return n - 1075;
    }

    static long significand(long l) {
        long l2 = l & 0xFFFFFFFFFFFFFL;
        if (!DoubleHelper.isDenormal(l)) {
            return l2 + 0x10000000000000L;
        }
        return l2;
    }

    static boolean isDenormal(long l) {
        return (l & 0x7FF0000000000000L) == 0L;
    }

    static boolean isSpecial(long l) {
        return (l & 0x7FF0000000000000L) == 0x7FF0000000000000L;
    }

    static boolean isNan(long l) {
        return (l & 0x7FF0000000000000L) == 0x7FF0000000000000L && (l & 0xFFFFFFFFFFFFFL) != 0L;
    }

    static boolean isInfinite(long l) {
        return (l & 0x7FF0000000000000L) == 0x7FF0000000000000L && (l & 0xFFFFFFFFFFFFFL) == 0L;
    }

    static int sign(long l) {
        return (l & Long.MIN_VALUE) == 0L ? 1 : -1;
    }

    static void normalizedBoundaries(long l, DiyFp diyFp, DiyFp diyFp2) {
        DiyFp diyFp3 = DoubleHelper.asDiyFp(l);
        boolean bl = diyFp3.f() == 0x10000000000000L;
        diyFp2.setF((diyFp3.f() << 1) + 1L);
        diyFp2.setE(diyFp3.e() - 1);
        diyFp2.normalize();
        if (bl && diyFp3.e() != -1074) {
            diyFp.setF((diyFp3.f() << 2) - 1L);
            diyFp.setE(diyFp3.e() - 2);
        } else {
            diyFp.setF((diyFp3.f() << 1) - 1L);
            diyFp.setE(diyFp3.e() - 1);
        }
        diyFp.setF(diyFp.f() << diyFp.e() - diyFp2.e());
        diyFp.setE(diyFp2.e());
    }
}

