/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VMBridge;

final class MemberBox
implements Serializable {
    private static final long serialVersionUID = 6358550398665688245L;
    private transient Member memberObject;
    transient Class<?>[] argTypes;
    transient boolean vararg;
    transient Function asGetterFunction;
    transient Function asSetterFunction;
    transient Object delegateTo;
    private static final Class<?>[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    MemberBox(Method method) {
        this.init(method);
    }

    MemberBox(Constructor<?> constructor) {
        this.init(constructor);
    }

    private void init(Method method) {
        this.memberObject = method;
        this.argTypes = method.getParameterTypes();
        this.vararg = method.isVarArgs();
    }

    private void init(Constructor<?> constructor) {
        this.memberObject = constructor;
        this.argTypes = constructor.getParameterTypes();
        this.vararg = constructor.isVarArgs();
    }

    Method method() {
        return (Method)this.memberObject;
    }

    Constructor<?> ctor() {
        return (Constructor)this.memberObject;
    }

    Member member() {
        return this.memberObject;
    }

    boolean isMethod() {
        return this.memberObject instanceof Method;
    }

    boolean isCtor() {
        return this.memberObject instanceof Constructor;
    }

    boolean isStatic() {
        return Modifier.isStatic(this.memberObject.getModifiers());
    }

    boolean isPublic() {
        return Modifier.isPublic(this.memberObject.getModifiers());
    }

    String getName() {
        return this.memberObject.getName();
    }

    Class<?> getDeclaringClass() {
        return this.memberObject.getDeclaringClass();
    }

    String toJavaDeclaration() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isMethod()) {
            Method method = this.method();
            stringBuilder.append(method.getReturnType());
            stringBuilder.append(' ');
            stringBuilder.append(method.getName());
        } else {
            Constructor<?> constructor = this.ctor();
            String string = constructor.getDeclaringClass().getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(JavaMembers.liveConnectSignature(this.argTypes));
        return stringBuilder.toString();
    }

    public String toString() {
        return this.memberObject.toString();
    }

    Function asGetterFunction(final String string, Scriptable scriptable) {
        if (this.asGetterFunction == null) {
            this.asGetterFunction = new BaseFunction(scriptable, ScriptableObject.getFunctionPrototype(scriptable)){

                @Override
                public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
                    Object[] objectArray2;
                    Object object;
                    MemberBox memberBox = MemberBox.this;
                    if (memberBox.delegateTo == null) {
                        object = scriptable2;
                        objectArray2 = ScriptRuntime.emptyArgs;
                    } else {
                        object = memberBox.delegateTo;
                        objectArray2 = new Object[]{scriptable2};
                    }
                    return memberBox.invoke(object, objectArray2);
                }

                @Override
                public String getFunctionName() {
                    return string;
                }
            };
        }
        return this.asGetterFunction;
    }

    Function asSetterFunction(final String string, Scriptable scriptable) {
        if (this.asSetterFunction == null) {
            this.asSetterFunction = new BaseFunction(scriptable, ScriptableObject.getFunctionPrototype(scriptable)){

                @Override
                public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
                    Object[] objectArray2;
                    Object object;
                    Object object2;
                    MemberBox memberBox = MemberBox.this;
                    Object object3 = object2 = objectArray.length > 0 ? FunctionObject.convertArg(context, scriptable2, objectArray[0], FunctionObject.getTypeTag(memberBox.argTypes[0])) : Undefined.instance;
                    if (memberBox.delegateTo == null) {
                        object = scriptable2;
                        objectArray2 = new Object[]{object2};
                    } else {
                        object = memberBox.delegateTo;
                        objectArray2 = new Object[]{scriptable2, object2};
                    }
                    return memberBox.invoke(object, objectArray2);
                }

                @Override
                public String getFunctionName() {
                    return string;
                }
            };
        }
        return this.asSetterFunction;
    }

    Object invoke(Object object, Object[] objectArray) {
        Method method = this.method();
        if (object instanceof Delegator) {
            object = ((Delegator)object).getDelegee();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Delegator)) continue;
            objectArray[i] = ((Delegator)objectArray[i]).getDelegee();
        }
        try {
            try {
                return method.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                Method method2 = MemberBox.searchAccessibleMethod(method, this.argTypes);
                if (method2 != null) {
                    this.memberObject = method2;
                    method = method2;
                } else if (!VMBridge.instance.tryToMakeAccessible(method)) {
                    throw Context.throwAsScriptRuntimeEx(illegalAccessException);
                }
                return method.invoke(object, objectArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException;
            while ((throwable = throwable.getTargetException()) instanceof InvocationTargetException) {
            }
            if (throwable instanceof ContinuationPending) {
                throw (ContinuationPending)throwable;
            }
            throw Context.throwAsScriptRuntimeEx(throwable);
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    Object newInstance(Object[] objectArray) {
        Constructor<?> constructor = this.ctor();
        try {
            try {
                return constructor.newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!VMBridge.instance.tryToMakeAccessible(constructor)) {
                    throw Context.throwAsScriptRuntimeEx(illegalAccessException);
                }
                return constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    private static Method searchAccessibleMethod(Method method, Class<?>[] classArray) {
        Class<?> clazz;
        int n = method.getModifiers();
        if (Modifier.isPublic(n) && !Modifier.isStatic(n) && !Modifier.isPublic((clazz = method.getDeclaringClass()).getModifiers())) {
            String string = method.getName();
            Class<?>[] classArray2 = clazz.getInterfaces();
            int n2 = classArray2.length;
            for (int i = 0; i != n2; ++i) {
                Class<?> clazz2 = classArray2[i];
                if (!Modifier.isPublic(clazz2.getModifiers())) continue;
                try {
                    return clazz2.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            while ((clazz = clazz.getSuperclass()) != null) {
                if (!Modifier.isPublic(clazz.getModifiers())) continue;
                try {
                    Method method2 = clazz.getMethod(string, classArray);
                    n2 = method2.getModifiers();
                    if (!Modifier.isPublic(n2) || Modifier.isStatic(n2)) continue;
                    return method2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Member member = MemberBox.readMember(objectInputStream);
        if (member instanceof Method) {
            this.init((Method)member);
        } else {
            this.init((Constructor)member);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        MemberBox.writeMember(objectOutputStream, this.memberObject);
    }

    private static void writeMember(ObjectOutputStream objectOutputStream, Member member) throws IOException {
        if (member == null) {
            objectOutputStream.writeBoolean(false);
            return;
        }
        objectOutputStream.writeBoolean(true);
        if (!(member instanceof Method) && !(member instanceof Constructor)) {
            throw new IllegalArgumentException("not Method or Constructor");
        }
        objectOutputStream.writeBoolean(member instanceof Method);
        objectOutputStream.writeObject(member.getName());
        objectOutputStream.writeObject(member.getDeclaringClass());
        if (member instanceof Method) {
            MemberBox.writeParameters(objectOutputStream, ((Method)member).getParameterTypes());
        } else {
            MemberBox.writeParameters(objectOutputStream, ((Constructor)member).getParameterTypes());
        }
    }

    private static Member readMember(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (!objectInputStream.readBoolean()) {
            return null;
        }
        boolean bl = objectInputStream.readBoolean();
        String string = (String)objectInputStream.readObject();
        Class clazz = (Class)objectInputStream.readObject();
        Class<?>[] classArray = MemberBox.readParameters(objectInputStream);
        try {
            if (bl) {
                return clazz.getMethod(string, classArray);
            }
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Cannot find member: " + noSuchMethodException);
        }
    }

    private static void writeParameters(ObjectOutputStream objectOutputStream, Class<?>[] classArray) throws IOException {
        objectOutputStream.writeShort(classArray.length);
        block0: for (Class<?> clazz : classArray) {
            boolean bl = clazz.isPrimitive();
            objectOutputStream.writeBoolean(bl);
            if (!bl) {
                objectOutputStream.writeObject(clazz);
                continue;
            }
            for (int i = 0; i < primitives.length; ++i) {
                if (!clazz.equals(primitives[i])) continue;
                objectOutputStream.writeByte(i);
                continue block0;
            }
            throw new IllegalArgumentException("Primitive " + clazz + " not found");
        }
    }

    private static Class<?>[] readParameters(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class[] classArray = new Class[objectInputStream.readShort()];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = !objectInputStream.readBoolean() ? (Class)objectInputStream.readObject() : primitives[objectInputStream.readByte()];
        }
        return classArray;
    }
}

