/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Undefined;

public class Hashtable
implements Serializable,
Iterable<Entry> {
    private static final long serialVersionUID = -7151554912419543747L;
    private final HashMap<Object, Entry> map = new HashMap();
    private Entry first = null;
    private Entry last = null;

    private static Entry makeDummy() {
        Entry entry = new Entry();
        entry.clear();
        return entry;
    }

    public int size() {
        return this.map.size();
    }

    public void put(Object object, Object object2) {
        Entry entry = new Entry(object, object2);
        if (!this.map.containsKey(entry)) {
            this.map.put(entry, entry);
            if (this.first == null) {
                this.first = this.last = entry;
            } else {
                this.last.next = entry;
                entry.prev = this.last;
                this.last = entry;
            }
        } else {
            this.map.get((Object)entry).value = object2;
        }
    }

    public Object get(Object object) {
        Entry entry = new Entry(object, null);
        Entry entry2 = this.map.get(entry);
        if (entry2 == null) {
            return null;
        }
        return entry2.value;
    }

    public Entry getEntry(Object object) {
        Entry entry = new Entry(object, null);
        return this.map.get(entry);
    }

    public boolean has(Object object) {
        Entry entry = new Entry(object, null);
        return this.map.containsKey(entry);
    }

    public Object delete(Object object) {
        Object object2;
        Entry entry = new Entry(object, null);
        Entry entry2 = this.map.remove(entry);
        if (entry2 == null) {
            return null;
        }
        if (entry2 == this.first) {
            if (entry2 == this.last) {
                entry2.clear();
                entry2.prev = null;
            } else {
                this.first = entry2.next;
                this.first.prev = null;
                if (this.first.next != null) {
                    this.first.next.prev = this.first;
                }
            }
        } else {
            object2 = entry2.prev;
            ((Entry)object2).next = entry2.next;
            entry2.prev = null;
            if (entry2.next != null) {
                entry2.next.prev = object2;
            } else {
                assert (entry2 == this.last);
                this.last = object2;
            }
        }
        object2 = entry2.value;
        entry2.clear();
        return object2;
    }

    public boolean deleteEntry(Object object) {
        Entry entry = new Entry(object, null);
        Entry entry2 = this.map.remove(entry);
        if (entry2 == null) {
            return false;
        }
        if (entry2 == this.first) {
            if (entry2 == this.last) {
                entry2.clear();
                entry2.prev = null;
            } else {
                this.first = entry2.next;
                this.first.prev = null;
                if (this.first.next != null) {
                    this.first.next.prev = this.first;
                }
            }
        } else {
            Entry entry3 = entry2.prev;
            entry3.next = entry2.next;
            entry2.prev = null;
            if (entry2.next != null) {
                entry2.next.prev = entry3;
            } else {
                assert (entry2 == this.last);
                this.last = entry3;
            }
        }
        entry2.clear();
        return true;
    }

    public void clear() {
        Iterator<Entry> iterator = this.iterator();
        iterator.forEachRemaining(Entry::clear);
        if (this.first != null) {
            Entry entry;
            this.last.next = entry = Hashtable.makeDummy();
            this.first = this.last = entry;
        }
        this.map.clear();
    }

    @Override
    public Iterator<Entry> iterator() {
        return new Iter(this.first);
    }

    public static final class Entry
    implements Serializable {
        private static final long serialVersionUID = 4086572107122965503L;
        protected Object key;
        protected Object value;
        protected boolean deleted;
        protected Entry next;
        protected Entry prev;
        private final int hashCode;

        Entry() {
            this.hashCode = 0;
        }

        Entry(Object object, Object object2) {
            this.key = object instanceof Number ? (object instanceof Double || object instanceof BigInteger ? object : Double.valueOf(((Number)object).doubleValue())) : (object instanceof ConsString ? object.toString() : object);
            this.hashCode = this.key == null ? 0 : (object.equals(ScriptRuntime.negativeZeroObj) ? 0 : this.key.hashCode());
            this.value = object2;
        }

        public Object key() {
            return this.key;
        }

        public Object value() {
            return this.value;
        }

        void clear() {
            this.key = Undefined.instance;
            this.value = Undefined.instance;
            this.deleted = true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            try {
                return ScriptRuntime.sameZero(this.key, ((Entry)object).key);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }

    private static final class Iter
    implements Iterator<Entry> {
        private Entry pos;

        Iter(Entry entry) {
            Entry entry2 = Hashtable.makeDummy();
            entry2.next = entry;
            this.pos = entry2;
        }

        private void skipDeleted() {
            while (this.pos.next != null && this.pos.next.deleted) {
                this.pos = this.pos.next;
            }
        }

        @Override
        public boolean hasNext() {
            this.skipDeleted();
            return this.pos != null && this.pos.next != null;
        }

        @Override
        public Entry next() {
            this.skipDeleted();
            if (this.pos == null || this.pos.next == null) {
                throw new NoSuchElementException();
            }
            Entry entry = this.pos.next;
            this.pos = this.pos.next;
            return entry;
        }
    }
}

