/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EqualObjectGraphs;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TopLevel;

public class BoundFunction
extends BaseFunction {
    private static final long serialVersionUID = 2118137342826470729L;
    private final Callable targetFunction;
    private final Scriptable boundThis;
    private final Object[] boundArgs;
    private final int length;

    public BoundFunction(Context context, Scriptable scriptable, Callable callable, Scriptable scriptable2, Object[] objectArray) {
        this.targetFunction = callable;
        this.boundThis = scriptable2;
        this.boundArgs = objectArray;
        this.length = callable instanceof BaseFunction ? Math.max(0, ((BaseFunction)callable).getLength() - objectArray.length) : 0;
        ScriptRuntime.setFunctionProtoAndParent(this, context, scriptable, false);
        BaseFunction baseFunction = ScriptRuntime.typeErrorThrower(context);
        NativeObject nativeObject = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
        nativeObject.put("get", (Scriptable)nativeObject, (Object)baseFunction);
        nativeObject.put("set", (Scriptable)nativeObject, (Object)baseFunction);
        nativeObject.put("enumerable", (Scriptable)nativeObject, (Object)Boolean.FALSE);
        nativeObject.put("configurable", (Scriptable)nativeObject, (Object)Boolean.FALSE);
        nativeObject.preventExtensions();
        this.defineOwnProperty(context, "caller", nativeObject, false);
        this.defineOwnProperty(context, "arguments", nativeObject, false);
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = this.boundThis;
        if (scriptable3 == null && ScriptRuntime.hasTopCall(context)) {
            scriptable3 = ScriptRuntime.getTopCallScope(context);
        }
        if (scriptable3 == null) {
            scriptable3 = BoundFunction.getTopLevelScope(scriptable);
        }
        return this.targetFunction.call(context, scriptable, scriptable3, BoundFunction.concat(this.boundArgs, objectArray));
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        if (this.targetFunction instanceof Function) {
            return ((Function)this.targetFunction).construct(context, scriptable, BoundFunction.concat(this.boundArgs, objectArray));
        }
        throw ScriptRuntime.typeErrorById("msg.not.ctor", new Object[0]);
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        if (this.targetFunction instanceof Function) {
            return ((Function)this.targetFunction).hasInstance(scriptable);
        }
        throw ScriptRuntime.typeErrorById("msg.not.ctor", new Object[0]);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getFunctionName() {
        if (this.targetFunction instanceof BaseFunction) {
            return "bound " + ((BaseFunction)this.targetFunction).getFunctionName();
        }
        return "";
    }

    private static Object[] concat(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    static boolean equalObjectGraphs(BoundFunction boundFunction, BoundFunction boundFunction2, EqualObjectGraphs equalObjectGraphs) {
        return equalObjectGraphs.equalGraphs(boundFunction.boundThis, boundFunction2.boundThis) && equalObjectGraphs.equalGraphs(boundFunction.targetFunction, boundFunction2.targetFunction) && equalObjectGraphs.equalGraphs(boundFunction.boundArgs, boundFunction2.boundArgs);
    }
}

