/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom.util;

import io.sf.carte.echosvg.constants.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XMLSupport
implements XMLConstants {
    private XMLSupport() {
    }

    public static String getXMLLang(Element element) {
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (attr != null) {
            return attr.getNodeValue();
        }
        for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 1 || (attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang")) == null) continue;
            return attr.getNodeValue();
        }
        return "en";
    }

    public static String getXMLSpace(Element element) {
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space");
        if (attr != null) {
            return attr.getNodeValue();
        }
        for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 1 || (attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space")) == null) continue;
            return attr.getNodeValue();
        }
        return "default";
    }

    public static String defaultXMLSpace(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    bl = false;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    if (bl) continue block4;
                    stringBuilder.append(' ');
                    bl = true;
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                    bl = false;
                }
            }
        }
        return stringBuilder.toString().trim();
    }

    public static String preserveXMLSpace(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuilder.append(' ');
                    continue block3;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

