/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AbstractElement;
import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedValue;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedLengthList;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.anim.values.AnimatableTransformListValue;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import io.sf.carte.echosvg.dom.svg.AbstractSVGList;
import io.sf.carte.echosvg.dom.svg.AbstractSVGTransformList;
import io.sf.carte.echosvg.dom.svg.ListBuilder;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.parser.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedTransformList;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;

public class SVGOMAnimatedTransformList
extends AbstractSVGAnimatedValue
implements SVGAnimatedTransformList {
    protected BaseSVGTransformList baseVal;
    protected AnimSVGTransformList animVal;
    protected boolean changing;
    protected String defaultValue;

    public SVGOMAnimatedTransformList(AbstractElement abstractElement, String string, String string2, String string3) {
        super(abstractElement, string, string2);
        this.defaultValue = string3;
    }

    public SVGTransformList getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGTransformList();
        }
        return this.baseVal;
    }

    public SVGTransformList getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGTransformList();
        }
        return this.animVal;
    }

    public void check() {
        if (!this.hasAnimVal) {
            if (this.baseVal == null) {
                this.baseVal = new BaseSVGTransformList();
            }
            this.baseVal.revalidate();
            if (this.baseVal.missing) {
                throw new LiveAttributeException((Element)((Object)this.element), this.localName, 0, null);
            }
            if (this.baseVal.malformed) {
                throw new LiveAttributeException((Element)((Object)this.element), this.localName, 1, this.baseVal.getValueAsString());
            }
        }
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGTransformList sVGTransformList = this.getBaseVal();
        int n = sVGTransformList.getNumberOfItems();
        ArrayList<SVGTransform> arrayList = new ArrayList<SVGTransform>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(sVGTransformList.getItem(i));
        }
        return new AnimatableTransformListValue(animationTarget, arrayList);
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableTransformListValue animatableTransformListValue = (AnimatableTransformListValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGTransformList();
            }
            this.animVal.setAnimatedValue(animatableTransformListValue.getTransforms());
        }
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGTransformList
    extends AbstractSVGTransformList {
        public AnimSVGTransformList() {
            this.itemList = new ArrayList(1);
        }

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedTransformList.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedTransformList.this.element).createSVGException(s, string, objectArray);
        }

        public int getNumberOfItems() {
            if (SVGOMAnimatedTransformList.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedTransformList.this.getBaseVal().getNumberOfItems();
        }

        public SVGTransform getItem(int n) throws DOMException {
            if (SVGOMAnimatedTransformList.this.hasAnimVal) {
                return super.getItem(n);
            }
            return SVGOMAnimatedTransformList.this.getBaseVal().getItem(n);
        }

        protected String getValueAsString() {
            if (this.itemList.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(this.itemList.size() * 8);
            Iterator iterator = this.itemList.iterator();
            if (iterator.hasNext()) {
                stringBuilder.append(((SVGItem)iterator.next()).getValueAsString());
            }
            while (iterator.hasNext()) {
                stringBuilder.append(this.getItemSeparator());
                stringBuilder.append(((SVGItem)iterator.next()).getValueAsString());
            }
            return stringBuilder.toString();
        }

        protected void setAttributeValue(String string) {
        }

        public void clear() throws DOMException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform initialize(SVGTransform sVGTransform) throws DOMException, SVGException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform insertItemBefore(SVGTransform sVGTransform, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform replaceItem(SVGTransform sVGTransform, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform removeItem(int n) throws DOMException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform appendItem(SVGTransform sVGTransform) throws DOMException {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        public SVGTransform consolidate() {
            throw SVGOMAnimatedTransformList.this.element.createDOMException((short)7, "readonly.transform.list", null);
        }

        protected void setAnimatedValue(Iterator<SVGTransform> iterator) {
            int n;
            int n2 = this.itemList.size();
            for (n = 0; n < n2 && iterator.hasNext(); ++n) {
                AbstractSVGTransformList.SVGTransformItem sVGTransformItem = (AbstractSVGTransformList.SVGTransformItem)this.itemList.get(n);
                sVGTransformItem.assign(iterator.next());
            }
            while (iterator.hasNext()) {
                this.appendItemImpl(new AbstractSVGTransformList.SVGTransformItem(iterator.next()));
                ++n;
            }
            while (n2 > n) {
                this.removeItemImpl(--n2);
            }
        }

        protected void setAnimatedValue(SVGTransform sVGTransform) {
            int n = this.itemList.size();
            while (n > 1) {
                this.removeItemImpl(--n);
            }
            if (n == 0) {
                this.appendItemImpl(new AbstractSVGTransformList.SVGTransformItem(sVGTransform));
            } else {
                AbstractSVGTransformList.SVGTransformItem sVGTransformItem = (AbstractSVGTransformList.SVGTransformItem)this.itemList.get(0);
                sVGTransformItem.assign(sVGTransform);
            }
        }

        protected void resetAttribute() {
        }

        protected void resetAttribute(SVGItem sVGItem) {
        }

        protected void revalidate() {
            this.valid = true;
        }
    }

    public class BaseSVGTransformList
    extends AbstractSVGTransformList {
        protected boolean missing;
        protected boolean malformed;

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedTransformList.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedTransformList.this.element).createSVGException(s, string, objectArray);
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedTransformList.this.element.getAttributeNodeNS(SVGOMAnimatedTransformList.this.namespaceURI, SVGOMAnimatedTransformList.this.localName);
            if (attr == null) {
                return SVGOMAnimatedTransformList.this.defaultValue;
            }
            return attr.getValue();
        }

        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedTransformList.this.changing = true;
                SVGOMAnimatedTransformList.this.element.setAttributeNS(SVGOMAnimatedTransformList.this.namespaceURI, SVGOMAnimatedTransformList.this.localName, string);
            }
            finally {
                SVGOMAnimatedTransformList.this.changing = false;
            }
        }

        protected void resetAttribute() {
            super.resetAttribute();
            this.missing = false;
            this.malformed = false;
        }

        protected void resetAttribute(SVGItem sVGItem) {
            super.resetAttribute(sVGItem);
            this.missing = false;
            this.malformed = false;
        }

        protected void revalidate() {
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String string = this.getValueAsString();
            if (string == null) {
                this.missing = true;
                return;
            }
            try {
                ListBuilder listBuilder = new ListBuilder((AbstractSVGList)this);
                this.doParse(string, (ListHandler)listBuilder);
                if (listBuilder.getList() != null) {
                    this.clear(this.itemList);
                }
                this.itemList = listBuilder.getList();
            }
            catch (ParseException parseException) {
                this.itemList = new ArrayList(1);
                this.malformed = true;
            }
        }

        public void copyTo(AbstractSVGList abstractSVGList) {
            super.copyTo(abstractSVGList);
            SVGOMAnimatedLengthList.BaseSVGLengthList baseSVGLengthList = (SVGOMAnimatedLengthList.BaseSVGLengthList)abstractSVGList;
            baseSVGLengthList.malformed = this.malformed;
            baseSVGLengthList.missing = this.missing;
        }
    }
}

