/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AbstractElement;
import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedValue;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.anim.values.AnimatablePointListValue;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import io.sf.carte.echosvg.dom.svg.AbstractSVGList;
import io.sf.carte.echosvg.dom.svg.AbstractSVGPointList;
import io.sf.carte.echosvg.dom.svg.ListBuilder;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.dom.svg.SVGPointItem;
import io.sf.carte.echosvg.parser.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedPoints;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class SVGOMAnimatedPoints
extends AbstractSVGAnimatedValue
implements SVGAnimatedPoints {
    protected BaseSVGPointList baseVal;
    protected AnimSVGPointList animVal;
    protected boolean changing;
    protected String defaultValue;

    public SVGOMAnimatedPoints(AbstractElement abstractElement, String string, String string2, String string3) {
        super(abstractElement, string, string2);
        this.defaultValue = string3;
    }

    public SVGPointList getPoints() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGPointList();
        }
        return this.baseVal;
    }

    public SVGPointList getAnimatedPoints() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGPointList();
        }
        return this.animVal;
    }

    public short check() {
        if (!this.hasAnimVal) {
            if (this.baseVal == null) {
                this.baseVal = new BaseSVGPointList();
            }
            this.baseVal.revalidate();
            if (this.baseVal.none) {
                return 0;
            }
            if (this.baseVal.malformed) {
                return 1;
            }
        }
        return -1;
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGPointList sVGPointList = this.getPoints();
        int n = sVGPointList.getNumberOfItems();
        float[] fArray = new float[n * 2];
        for (int i = 0; i < n; ++i) {
            SVGPoint sVGPoint = sVGPointList.getItem(i);
            fArray[i * 2] = sVGPoint.getX();
            fArray[i * 2 + 1] = sVGPoint.getY();
        }
        return new AnimatablePointListValue(animationTarget, fArray);
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatablePointListValue animatablePointListValue = (AnimatablePointListValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGPointList();
            }
            this.animVal.setAnimatedValue(animatablePointListValue.getNumbers());
        }
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGPointList
    extends AbstractSVGPointList {
        public AnimSVGPointList() {
            this.itemList = new ArrayList(1);
        }

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedPoints.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedPoints.this.element).createSVGException(s, string, objectArray);
        }

        public int getNumberOfItems() {
            if (SVGOMAnimatedPoints.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedPoints.this.getPoints().getNumberOfItems();
        }

        public SVGPoint getItem(int n) throws DOMException {
            if (SVGOMAnimatedPoints.this.hasAnimVal) {
                return super.getItem(n);
            }
            return SVGOMAnimatedPoints.this.getPoints().getItem(n);
        }

        protected String getValueAsString() {
            if (this.itemList.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(this.itemList.size() * 8);
            Iterator iterator = this.itemList.iterator();
            if (iterator.hasNext()) {
                stringBuilder.append(((SVGItem)iterator.next()).getValueAsString());
            }
            while (iterator.hasNext()) {
                stringBuilder.append(this.getItemSeparator());
                stringBuilder.append(((SVGItem)iterator.next()).getValueAsString());
            }
            return stringBuilder.toString();
        }

        protected void setAttributeValue(String string) {
        }

        public void clear() throws DOMException {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        public SVGPoint initialize(SVGPoint sVGPoint) throws DOMException, SVGException {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        public SVGPoint insertItemBefore(SVGPoint sVGPoint, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        public SVGPoint replaceItem(SVGPoint sVGPoint, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        public SVGPoint removeItem(int n) throws DOMException {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        public SVGPoint appendItem(SVGPoint sVGPoint) throws DOMException {
            throw SVGOMAnimatedPoints.this.element.createDOMException((short)7, "readonly.point.list", null);
        }

        protected void setAnimatedValue(float[] fArray) {
            int n;
            int n2 = this.itemList.size();
            for (n = 0; n < n2 && n < fArray.length / 2; ++n) {
                SVGPointItem sVGPointItem = (SVGPointItem)this.itemList.get(n);
                sVGPointItem.setX(fArray[n * 2]);
                sVGPointItem.setY(fArray[n * 2 + 1]);
            }
            while (n < fArray.length / 2) {
                this.appendItemImpl(new SVGPointItem(fArray[n * 2], fArray[n * 2 + 1]));
                ++n;
            }
            while (n2 > fArray.length / 2) {
                this.removeItemImpl(--n2);
            }
        }

        protected void resetAttribute() {
        }

        protected void resetAttribute(SVGItem sVGItem) {
        }

        protected void revalidate() {
            this.valid = true;
        }
    }

    protected class BaseSVGPointList
    extends AbstractSVGPointList {
        protected boolean none;
        protected boolean malformed;

        protected BaseSVGPointList() {
        }

        boolean isValid() {
            return this.valid;
        }

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedPoints.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedPoints.this.element).createSVGException(s, string, objectArray);
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedPoints.this.element.getAttributeNodeNS(SVGOMAnimatedPoints.this.namespaceURI, SVGOMAnimatedPoints.this.localName);
            if (attr == null) {
                return SVGOMAnimatedPoints.this.defaultValue;
            }
            return attr.getValue();
        }

        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedPoints.this.changing = true;
                SVGOMAnimatedPoints.this.element.setAttributeNS(SVGOMAnimatedPoints.this.namespaceURI, SVGOMAnimatedPoints.this.localName, string);
            }
            finally {
                SVGOMAnimatedPoints.this.changing = false;
            }
        }

        protected void resetAttribute() {
            super.resetAttribute();
            this.none = false;
            this.malformed = false;
        }

        protected void resetAttribute(SVGItem sVGItem) {
            super.resetAttribute(sVGItem);
            this.none = false;
            this.malformed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void revalidate() {
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.none = false;
            this.malformed = false;
            String string = this.getValueAsString().trim();
            if (string.isEmpty()) {
                this.none = true;
                this.clear(this.itemList);
                this.itemList = new ArrayList(1);
                return;
            }
            ListBuilder listBuilder = new ListBuilder((AbstractSVGList)this);
            try {
                this.doParse(string, (ListHandler)listBuilder);
            }
            catch (ParseException parseException) {
                this.malformed = true;
            }
            finally {
                this.clear(this.itemList);
                List list = listBuilder.getList();
                this.itemList = list != null ? list : new ArrayList(1);
            }
        }

        public void copyTo(AbstractSVGList abstractSVGList) {
            super.copyTo(abstractSVGList);
            BaseSVGPointList baseSVGPointList = (BaseSVGPointList)abstractSVGList;
            baseSVGPointList.malformed = this.malformed;
            baseSVGPointList.none = this.none;
        }
    }
}

