/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.CSSFontFace;
import io.sf.carte.echosvg.bridge.FontFace;
import io.sf.carte.echosvg.bridge.SVGFontFaceElementBridge;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.FontFaceRule;
import io.sf.carte.echosvg.gvt.font.GVTFontFamily;
import io.sf.carte.echosvg.gvt.font.UnresolvedFontFamily;
import io.sf.carte.echosvg.util.SVGConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class SVGFontUtilities
implements SVGConstants {
    public static List<FontFace> getFontFaces(Document document, BridgeContext bridgeContext) {
        Object object;
        Map<Object, Object> map = bridgeContext.getFontFamilyMap();
        LinkedList<FontFace> linkedList = (LinkedList<FontFace>)map.get(document);
        if (linkedList != null) {
            return linkedList;
        }
        linkedList = new LinkedList<FontFace>();
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "font-face");
        SVGFontFaceElementBridge sVGFontFaceElementBridge = (SVGFontFaceElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "font-face");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = (Element)nodeList.item(i);
            linkedList.add(sVGFontFaceElementBridge.createFontFace(bridgeContext, (Element)object));
        }
        CSSEngine cSSEngine = ((SVGOMDocument)document).getCSSEngine();
        object = cSSEngine.getFontFaces();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            FontFaceRule fontFaceRule = (FontFaceRule)iterator.next();
            linkedList.add(CSSFontFace.createCSSFontFace(cSSEngine, fontFaceRule));
        }
        return linkedList;
    }

    public static GVTFontFamily getFontFamily(Element element, BridgeContext bridgeContext, String string, String string2, String string3) {
        Object object;
        ArrayList<String> arrayList;
        String string4 = string.toLowerCase() + " " + string2 + " " + string3;
        Map<Object, Object> map = bridgeContext.getFontFamilyMap();
        GVTFontFamily gVTFontFamily = (GVTFontFamily)map.get(string4);
        if (gVTFontFamily != null) {
            return gVTFontFamily;
        }
        Document document = element.getOwnerDocument();
        List<FontFace> list = (List<FontFace>)map.get(document);
        if (list == null) {
            list = SVGFontUtilities.getFontFaces(document, bridgeContext);
            map.put(document, list);
        }
        LinkedList<GVTFontFamily> linkedList = new LinkedList<GVTFontFamily>();
        for (FontFace object2 : list) {
            GVTFontFamily n2;
            if (!object2.hasFamilyName(string) || !((String)((Object)(arrayList = object2.getFontStyle()))).equals("all") && ((String)((Object)arrayList)).indexOf(string3) == -1 || (n2 = object2.getFontFamily(bridgeContext)) == null) continue;
            linkedList.add(n2);
        }
        if (linkedList.size() == 1) {
            map.put(string4, linkedList.get(0));
            return (GVTFontFamily)linkedList.get(0);
        }
        if (linkedList.size() > 1) {
            int n;
            Object object2;
            object = SVGFontUtilities.getFontWeightNumberString(string2);
            ArrayList<String> arrayList2 = new ArrayList<String>(linkedList.size());
            for (GVTFontFamily n2 : linkedList) {
                object2 = n2.getFontFace();
                String string5 = object2.getFontWeight();
                string5 = SVGFontUtilities.getFontWeightNumberString(string5);
                arrayList2.add(string5);
            }
            arrayList = new ArrayList<String>(arrayList2);
            for (n = 100; n <= 900; n += 100) {
                object2 = String.valueOf(n);
                boolean bl = false;
                int n3 = 1000;
                int n4 = 0;
                for (int string7 = 0; string7 < arrayList2.size(); ++string7) {
                    String string6 = (String)arrayList2.get(string7);
                    if (string6.indexOf((String)object2) > -1) {
                        bl = true;
                        break;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, " ,");
                    while (stringTokenizer.hasMoreTokens()) {
                        int n5 = Integer.parseInt(stringTokenizer.nextToken());
                        int n6 = Math.abs(n5 - n);
                        if (n6 >= n3) continue;
                        n3 = n6;
                        n4 = string7;
                    }
                }
                if (bl) continue;
                String string7 = (String)arrayList.get(n4) + ", " + (String)object2;
                arrayList.set(n4, string7);
            }
            for (n = 0; n < linkedList.size(); ++n) {
                object2 = (String)arrayList.get(n);
                if (((String)object2).indexOf((String)object) <= -1) continue;
                map.put(string4, linkedList.get(n));
                return (GVTFontFamily)linkedList.get(n);
            }
            map.put(string4, linkedList.get(0));
            return (GVTFontFamily)linkedList.get(0);
        }
        object = new UnresolvedFontFamily(string);
        map.put(string4, object);
        return object;
    }

    protected static String getFontWeightNumberString(String string) {
        if (string.equals("normal")) {
            return "400";
        }
        if (string.equals("bold")) {
            return "700";
        }
        if (string.equals("all")) {
            return "100, 200, 300, 400, 500, 600, 700, 800, 900";
        }
        return string;
    }
}

