/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.AbstractSVGLightingElementBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.ext.awt.image.Light;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.SpecularLightingRable8Bit;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.w3c.dom.Element;

public class SVGFeSpecularLightingElementBridge
extends AbstractSVGLightingElementBridge {
    @Override
    public String getLocalName() {
        return "feSpecularLighting";
    }

    @Override
    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map<String, Filter> map) {
        float f = SVGFeSpecularLightingElementBridge.convertNumber(element, "surfaceScale", 1.0f, bridgeContext);
        float f2 = SVGFeSpecularLightingElementBridge.convertNumber(element, "specularConstant", 1.0f, bridgeContext);
        float f3 = SVGFeSpecularLightingElementBridge.convertSpecularExponent(element, bridgeContext);
        Light light = SVGFeSpecularLightingElementBridge.extractLight(element, bridgeContext);
        double[] dArray = SVGFeSpecularLightingElementBridge.convertKernelUnitLength(element, bridgeContext);
        Filter filter2 = SVGFeSpecularLightingElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        SpecularLightingRable8Bit specularLightingRable8Bit = new SpecularLightingRable8Bit(filter2, rectangle2D3, light, (double)f2, (double)f3, (double)f, dArray);
        SVGFeSpecularLightingElementBridge.handleColorInterpolationFilters((Filter)specularLightingRable8Bit, element);
        SVGFeSpecularLightingElementBridge.updateFilterMap(element, (Filter)specularLightingRable8Bit, map);
        return specularLightingRable8Bit;
    }

    protected static float convertSpecularExponent(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "specularExponent");
        if (string.length() == 0) {
            return 1.0f;
        }
        try {
            float f = SVGUtilities.convertSVGNumber(string);
            if (f < 1.0f || f > 128.0f) {
                throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"specularConstant", string});
            }
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"specularConstant", string, numberFormatException});
        }
    }
}

