// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: containers.proto
// Original file comments:
//
// Copyright The containerd Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_containers_2eproto__INCLUDED
#define GRPC_containers_2eproto__INCLUDED

#include "containers.pb.h"

#include <functional>
#include <grpcpp/generic/async_generic_service.h>
#include <grpcpp/support/async_stream.h>
#include <grpcpp/support/async_unary_call.h>
#include <grpcpp/support/client_callback.h>
#include <grpcpp/client_context.h>
#include <grpcpp/completion_queue.h>
#include <grpcpp/support/message_allocator.h>
#include <grpcpp/support/method_handler.h>
#include <grpcpp/impl/proto_utils.h>
#include <grpcpp/impl/rpc_method.h>
#include <grpcpp/support/server_callback.h>
#include <grpcpp/impl/server_callback_handlers.h>
#include <grpcpp/server_context.h>
#include <grpcpp/impl/service_type.h>
#include <grpcpp/support/status.h>
#include <grpcpp/support/stub_options.h>
#include <grpcpp/support/sync_stream.h>
#include <grpcpp/ports_def.inc>

namespace containerd {
namespace services {
namespace containers {
namespace v1 {

// Containers provides metadata storage for containers used in the execution
// service.
//
// The objects here provide an state-independent view of containers for use in
// management and resource pinning. From that perspective, containers do not
// have a "state" but rather this is the set of resources that will be
// considered in use by the container.
//
// From the perspective of the execution service, these objects represent the
// base parameters for creating a container process.
//
// In general, when looking to add fields for this type, first ask yourself
// whether or not the function of the field has to do with runtime execution or
// is invariant of the runtime state of the container. If it has to do with
// runtime, or changes as the "container" is started and stops, it probably
// doesn't belong on this object.
class Containers final {
 public:
  static constexpr char const* service_full_name() {
    return "containerd.services.containers.v1.Containers";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    virtual ::grpc::Status Get(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest& request, ::containerd::services::containers::v1::GetContainerResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::GetContainerResponse>> AsyncGet(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::GetContainerResponse>>(AsyncGetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::GetContainerResponse>> PrepareAsyncGet(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::GetContainerResponse>>(PrepareAsyncGetRaw(context, request, cq));
    }
    virtual ::grpc::Status List(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::containerd::services::containers::v1::ListContainersResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::ListContainersResponse>> AsyncList(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::ListContainersResponse>>(AsyncListRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::ListContainersResponse>> PrepareAsyncList(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::ListContainersResponse>>(PrepareAsyncListRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReaderInterface< ::containerd::services::containers::v1::ListContainerMessage>> ListStream(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request) {
      return std::unique_ptr< ::grpc::ClientReaderInterface< ::containerd::services::containers::v1::ListContainerMessage>>(ListStreamRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::containerd::services::containers::v1::ListContainerMessage>> AsyncListStream(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::containerd::services::containers::v1::ListContainerMessage>>(AsyncListStreamRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::containerd::services::containers::v1::ListContainerMessage>> PrepareAsyncListStream(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::containerd::services::containers::v1::ListContainerMessage>>(PrepareAsyncListStreamRaw(context, request, cq));
    }
    virtual ::grpc::Status Create(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest& request, ::containerd::services::containers::v1::CreateContainerResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::CreateContainerResponse>> AsyncCreate(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::CreateContainerResponse>>(AsyncCreateRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::CreateContainerResponse>> PrepareAsyncCreate(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::CreateContainerResponse>>(PrepareAsyncCreateRaw(context, request, cq));
    }
    virtual ::grpc::Status Update(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest& request, ::containerd::services::containers::v1::UpdateContainerResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::UpdateContainerResponse>> AsyncUpdate(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::UpdateContainerResponse>>(AsyncUpdateRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::UpdateContainerResponse>> PrepareAsyncUpdate(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::UpdateContainerResponse>>(PrepareAsyncUpdateRaw(context, request, cq));
    }
    virtual ::grpc::Status Delete(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDelete(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDelete(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      virtual void Get(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest* request, ::containerd::services::containers::v1::GetContainerResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Get(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest* request, ::containerd::services::containers::v1::GetContainerResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      virtual void List(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest* request, ::containerd::services::containers::v1::ListContainersResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void List(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest* request, ::containerd::services::containers::v1::ListContainersResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      virtual void ListStream(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest* request, ::grpc::ClientReadReactor< ::containerd::services::containers::v1::ListContainerMessage>* reactor) = 0;
      virtual void Create(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest* request, ::containerd::services::containers::v1::CreateContainerResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Create(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest* request, ::containerd::services::containers::v1::CreateContainerResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      virtual void Update(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest* request, ::containerd::services::containers::v1::UpdateContainerResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Update(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest* request, ::containerd::services::containers::v1::UpdateContainerResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      virtual void Delete(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Delete(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::GetContainerResponse>* AsyncGetRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::GetContainerResponse>* PrepareAsyncGetRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::ListContainersResponse>* AsyncListRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::ListContainersResponse>* PrepareAsyncListRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderInterface< ::containerd::services::containers::v1::ListContainerMessage>* ListStreamRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::containerd::services::containers::v1::ListContainerMessage>* AsyncListStreamRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::containerd::services::containers::v1::ListContainerMessage>* PrepareAsyncListStreamRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::CreateContainerResponse>* AsyncCreateRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::CreateContainerResponse>* PrepareAsyncCreateRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::UpdateContainerResponse>* AsyncUpdateRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::containers::v1::UpdateContainerResponse>* PrepareAsyncUpdateRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status Get(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest& request, ::containerd::services::containers::v1::GetContainerResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::GetContainerResponse>> AsyncGet(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::GetContainerResponse>>(AsyncGetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::GetContainerResponse>> PrepareAsyncGet(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::GetContainerResponse>>(PrepareAsyncGetRaw(context, request, cq));
    }
    ::grpc::Status List(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::containerd::services::containers::v1::ListContainersResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::ListContainersResponse>> AsyncList(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::ListContainersResponse>>(AsyncListRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::ListContainersResponse>> PrepareAsyncList(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::ListContainersResponse>>(PrepareAsyncListRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReader< ::containerd::services::containers::v1::ListContainerMessage>> ListStream(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request) {
      return std::unique_ptr< ::grpc::ClientReader< ::containerd::services::containers::v1::ListContainerMessage>>(ListStreamRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::containerd::services::containers::v1::ListContainerMessage>> AsyncListStream(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::containerd::services::containers::v1::ListContainerMessage>>(AsyncListStreamRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::containerd::services::containers::v1::ListContainerMessage>> PrepareAsyncListStream(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::containerd::services::containers::v1::ListContainerMessage>>(PrepareAsyncListStreamRaw(context, request, cq));
    }
    ::grpc::Status Create(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest& request, ::containerd::services::containers::v1::CreateContainerResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::CreateContainerResponse>> AsyncCreate(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::CreateContainerResponse>>(AsyncCreateRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::CreateContainerResponse>> PrepareAsyncCreate(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::CreateContainerResponse>>(PrepareAsyncCreateRaw(context, request, cq));
    }
    ::grpc::Status Update(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest& request, ::containerd::services::containers::v1::UpdateContainerResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::UpdateContainerResponse>> AsyncUpdate(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::UpdateContainerResponse>>(AsyncUpdateRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::UpdateContainerResponse>> PrepareAsyncUpdate(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::UpdateContainerResponse>>(PrepareAsyncUpdateRaw(context, request, cq));
    }
    ::grpc::Status Delete(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDelete(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDelete(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void Get(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest* request, ::containerd::services::containers::v1::GetContainerResponse* response, std::function<void(::grpc::Status)>) override;
      void Get(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest* request, ::containerd::services::containers::v1::GetContainerResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void List(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest* request, ::containerd::services::containers::v1::ListContainersResponse* response, std::function<void(::grpc::Status)>) override;
      void List(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest* request, ::containerd::services::containers::v1::ListContainersResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListStream(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest* request, ::grpc::ClientReadReactor< ::containerd::services::containers::v1::ListContainerMessage>* reactor) override;
      void Create(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest* request, ::containerd::services::containers::v1::CreateContainerResponse* response, std::function<void(::grpc::Status)>) override;
      void Create(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest* request, ::containerd::services::containers::v1::CreateContainerResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Update(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest* request, ::containerd::services::containers::v1::UpdateContainerResponse* response, std::function<void(::grpc::Status)>) override;
      void Update(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest* request, ::containerd::services::containers::v1::UpdateContainerResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Delete(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void Delete(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::GetContainerResponse>* AsyncGetRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::GetContainerResponse>* PrepareAsyncGetRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::GetContainerRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::ListContainersResponse>* AsyncListRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::ListContainersResponse>* PrepareAsyncListRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReader< ::containerd::services::containers::v1::ListContainerMessage>* ListStreamRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request) override;
    ::grpc::ClientAsyncReader< ::containerd::services::containers::v1::ListContainerMessage>* AsyncListStreamRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReader< ::containerd::services::containers::v1::ListContainerMessage>* PrepareAsyncListStreamRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::ListContainersRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::CreateContainerResponse>* AsyncCreateRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::CreateContainerResponse>* PrepareAsyncCreateRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::CreateContainerRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::UpdateContainerResponse>* AsyncUpdateRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::containers::v1::UpdateContainerResponse>* PrepareAsyncUpdateRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteRaw(::grpc::ClientContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_Get_;
    const ::grpc::internal::RpcMethod rpcmethod_List_;
    const ::grpc::internal::RpcMethod rpcmethod_ListStream_;
    const ::grpc::internal::RpcMethod rpcmethod_Create_;
    const ::grpc::internal::RpcMethod rpcmethod_Update_;
    const ::grpc::internal::RpcMethod rpcmethod_Delete_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    virtual ::grpc::Status Get(::grpc::ServerContext* context, const ::containerd::services::containers::v1::GetContainerRequest* request, ::containerd::services::containers::v1::GetContainerResponse* response);
    virtual ::grpc::Status List(::grpc::ServerContext* context, const ::containerd::services::containers::v1::ListContainersRequest* request, ::containerd::services::containers::v1::ListContainersResponse* response);
    virtual ::grpc::Status ListStream(::grpc::ServerContext* context, const ::containerd::services::containers::v1::ListContainersRequest* request, ::grpc::ServerWriter< ::containerd::services::containers::v1::ListContainerMessage>* writer);
    virtual ::grpc::Status Create(::grpc::ServerContext* context, const ::containerd::services::containers::v1::CreateContainerRequest* request, ::containerd::services::containers::v1::CreateContainerResponse* response);
    virtual ::grpc::Status Update(::grpc::ServerContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest* request, ::containerd::services::containers::v1::UpdateContainerResponse* response);
    virtual ::grpc::Status Delete(::grpc::ServerContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest* request, ::google::protobuf::Empty* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Get() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::GetContainerRequest* /*request*/, ::containerd::services::containers::v1::GetContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGet(::grpc::ServerContext* context, ::containerd::services::containers::v1::GetContainerRequest* request, ::grpc::ServerAsyncResponseWriter< ::containerd::services::containers::v1::GetContainerResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_List() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::containerd::services::containers::v1::ListContainersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestList(::grpc::ServerContext* context, ::containerd::services::containers::v1::ListContainersRequest* request, ::grpc::ServerAsyncResponseWriter< ::containerd::services::containers::v1::ListContainersResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListStream() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_ListStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListStream(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::grpc::ServerWriter< ::containerd::services::containers::v1::ListContainerMessage>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListStream(::grpc::ServerContext* context, ::containerd::services::containers::v1::ListContainersRequest* request, ::grpc::ServerAsyncWriter< ::containerd::services::containers::v1::ListContainerMessage>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(2, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Create() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::CreateContainerRequest* /*request*/, ::containerd::services::containers::v1::CreateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreate(::grpc::ServerContext* context, ::containerd::services::containers::v1::CreateContainerRequest* request, ::grpc::ServerAsyncResponseWriter< ::containerd::services::containers::v1::CreateContainerResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Update() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::UpdateContainerRequest* /*request*/, ::containerd::services::containers::v1::UpdateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdate(::grpc::ServerContext* context, ::containerd::services::containers::v1::UpdateContainerRequest* request, ::grpc::ServerAsyncResponseWriter< ::containerd::services::containers::v1::UpdateContainerResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Delete() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::DeleteContainerRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDelete(::grpc::ServerContext* context, ::containerd::services::containers::v1::DeleteContainerRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_Get<WithAsyncMethod_List<WithAsyncMethod_ListStream<WithAsyncMethod_Create<WithAsyncMethod_Update<WithAsyncMethod_Delete<Service > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Get() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::containerd::services::containers::v1::GetContainerRequest, ::containerd::services::containers::v1::GetContainerResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::containers::v1::GetContainerRequest* request, ::containerd::services::containers::v1::GetContainerResponse* response) { return this->Get(context, request, response); }));}
    void SetMessageAllocatorFor_Get(
        ::grpc::MessageAllocator< ::containerd::services::containers::v1::GetContainerRequest, ::containerd::services::containers::v1::GetContainerResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::containerd::services::containers::v1::GetContainerRequest, ::containerd::services::containers::v1::GetContainerResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::GetContainerRequest* /*request*/, ::containerd::services::containers::v1::GetContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Get(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::containers::v1::GetContainerRequest* /*request*/, ::containerd::services::containers::v1::GetContainerResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_List() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::containerd::services::containers::v1::ListContainersRequest, ::containerd::services::containers::v1::ListContainersResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::containers::v1::ListContainersRequest* request, ::containerd::services::containers::v1::ListContainersResponse* response) { return this->List(context, request, response); }));}
    void SetMessageAllocatorFor_List(
        ::grpc::MessageAllocator< ::containerd::services::containers::v1::ListContainersRequest, ::containerd::services::containers::v1::ListContainersResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::containerd::services::containers::v1::ListContainersRequest, ::containerd::services::containers::v1::ListContainersResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::containerd::services::containers::v1::ListContainersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* List(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::containerd::services::containers::v1::ListContainersResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListStream() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackServerStreamingHandler< ::containerd::services::containers::v1::ListContainersRequest, ::containerd::services::containers::v1::ListContainerMessage>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::containers::v1::ListContainersRequest* request) { return this->ListStream(context, request); }));
    }
    ~WithCallbackMethod_ListStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListStream(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::grpc::ServerWriter< ::containerd::services::containers::v1::ListContainerMessage>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::containerd::services::containers::v1::ListContainerMessage>* ListStream(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Create() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::containerd::services::containers::v1::CreateContainerRequest, ::containerd::services::containers::v1::CreateContainerResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::containers::v1::CreateContainerRequest* request, ::containerd::services::containers::v1::CreateContainerResponse* response) { return this->Create(context, request, response); }));}
    void SetMessageAllocatorFor_Create(
        ::grpc::MessageAllocator< ::containerd::services::containers::v1::CreateContainerRequest, ::containerd::services::containers::v1::CreateContainerResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::containerd::services::containers::v1::CreateContainerRequest, ::containerd::services::containers::v1::CreateContainerResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::CreateContainerRequest* /*request*/, ::containerd::services::containers::v1::CreateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Create(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::containers::v1::CreateContainerRequest* /*request*/, ::containerd::services::containers::v1::CreateContainerResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Update() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::containerd::services::containers::v1::UpdateContainerRequest, ::containerd::services::containers::v1::UpdateContainerResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::containers::v1::UpdateContainerRequest* request, ::containerd::services::containers::v1::UpdateContainerResponse* response) { return this->Update(context, request, response); }));}
    void SetMessageAllocatorFor_Update(
        ::grpc::MessageAllocator< ::containerd::services::containers::v1::UpdateContainerRequest, ::containerd::services::containers::v1::UpdateContainerResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::containerd::services::containers::v1::UpdateContainerRequest, ::containerd::services::containers::v1::UpdateContainerResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::UpdateContainerRequest* /*request*/, ::containerd::services::containers::v1::UpdateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Update(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::containers::v1::UpdateContainerRequest* /*request*/, ::containerd::services::containers::v1::UpdateContainerResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Delete() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::containerd::services::containers::v1::DeleteContainerRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::containers::v1::DeleteContainerRequest* request, ::google::protobuf::Empty* response) { return this->Delete(context, request, response); }));}
    void SetMessageAllocatorFor_Delete(
        ::grpc::MessageAllocator< ::containerd::services::containers::v1::DeleteContainerRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::containerd::services::containers::v1::DeleteContainerRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::DeleteContainerRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Delete(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::containers::v1::DeleteContainerRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_Get<WithCallbackMethod_List<WithCallbackMethod_ListStream<WithCallbackMethod_Create<WithCallbackMethod_Update<WithCallbackMethod_Delete<Service > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Get() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::GetContainerRequest* /*request*/, ::containerd::services::containers::v1::GetContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_List() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::containerd::services::containers::v1::ListContainersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListStream() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_ListStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListStream(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::grpc::ServerWriter< ::containerd::services::containers::v1::ListContainerMessage>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Create() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::CreateContainerRequest* /*request*/, ::containerd::services::containers::v1::CreateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Update() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::UpdateContainerRequest* /*request*/, ::containerd::services::containers::v1::UpdateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Delete() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::DeleteContainerRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Get() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::GetContainerRequest* /*request*/, ::containerd::services::containers::v1::GetContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGet(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_List() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::containerd::services::containers::v1::ListContainersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestList(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListStream() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_ListStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListStream(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::grpc::ServerWriter< ::containerd::services::containers::v1::ListContainerMessage>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListStream(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncWriter< ::grpc::ByteBuffer>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(2, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Create() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::CreateContainerRequest* /*request*/, ::containerd::services::containers::v1::CreateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreate(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Update() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::UpdateContainerRequest* /*request*/, ::containerd::services::containers::v1::UpdateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdate(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Delete() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::DeleteContainerRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDelete(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Get() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Get(context, request, response); }));
    }
    ~WithRawCallbackMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::GetContainerRequest* /*request*/, ::containerd::services::containers::v1::GetContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Get(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_List() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->List(context, request, response); }));
    }
    ~WithRawCallbackMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::containerd::services::containers::v1::ListContainersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* List(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListStream() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackServerStreamingHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const::grpc::ByteBuffer* request) { return this->ListStream(context, request); }));
    }
    ~WithRawCallbackMethod_ListStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListStream(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::grpc::ServerWriter< ::containerd::services::containers::v1::ListContainerMessage>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::grpc::ByteBuffer>* ListStream(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Create() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Create(context, request, response); }));
    }
    ~WithRawCallbackMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::CreateContainerRequest* /*request*/, ::containerd::services::containers::v1::CreateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Create(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Update() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Update(context, request, response); }));
    }
    ~WithRawCallbackMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::UpdateContainerRequest* /*request*/, ::containerd::services::containers::v1::UpdateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Update(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Delete() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Delete(context, request, response); }));
    }
    ~WithRawCallbackMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::DeleteContainerRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Delete(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Get() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::containerd::services::containers::v1::GetContainerRequest, ::containerd::services::containers::v1::GetContainerResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::containerd::services::containers::v1::GetContainerRequest, ::containerd::services::containers::v1::GetContainerResponse>* streamer) {
                       return this->StreamedGet(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::GetContainerRequest* /*request*/, ::containerd::services::containers::v1::GetContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGet(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::containerd::services::containers::v1::GetContainerRequest,::containerd::services::containers::v1::GetContainerResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_List() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::containerd::services::containers::v1::ListContainersRequest, ::containerd::services::containers::v1::ListContainersResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::containerd::services::containers::v1::ListContainersRequest, ::containerd::services::containers::v1::ListContainersResponse>* streamer) {
                       return this->StreamedList(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::containerd::services::containers::v1::ListContainersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedList(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::containerd::services::containers::v1::ListContainersRequest,::containerd::services::containers::v1::ListContainersResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Create() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::containerd::services::containers::v1::CreateContainerRequest, ::containerd::services::containers::v1::CreateContainerResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::containerd::services::containers::v1::CreateContainerRequest, ::containerd::services::containers::v1::CreateContainerResponse>* streamer) {
                       return this->StreamedCreate(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::CreateContainerRequest* /*request*/, ::containerd::services::containers::v1::CreateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreate(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::containerd::services::containers::v1::CreateContainerRequest,::containerd::services::containers::v1::CreateContainerResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Update() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::containerd::services::containers::v1::UpdateContainerRequest, ::containerd::services::containers::v1::UpdateContainerResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::containerd::services::containers::v1::UpdateContainerRequest, ::containerd::services::containers::v1::UpdateContainerResponse>* streamer) {
                       return this->StreamedUpdate(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::UpdateContainerRequest* /*request*/, ::containerd::services::containers::v1::UpdateContainerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdate(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::containerd::services::containers::v1::UpdateContainerRequest,::containerd::services::containers::v1::UpdateContainerResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Delete() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::containerd::services::containers::v1::DeleteContainerRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::containerd::services::containers::v1::DeleteContainerRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDelete(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::DeleteContainerRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDelete(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::containerd::services::containers::v1::DeleteContainerRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_Get<WithStreamedUnaryMethod_List<WithStreamedUnaryMethod_Create<WithStreamedUnaryMethod_Update<WithStreamedUnaryMethod_Delete<Service > > > > > StreamedUnaryService;
  template <class BaseClass>
  class WithSplitStreamingMethod_ListStream : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithSplitStreamingMethod_ListStream() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::SplitServerStreamingHandler<
          ::containerd::services::containers::v1::ListContainersRequest, ::containerd::services::containers::v1::ListContainerMessage>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerSplitStreamer<
                     ::containerd::services::containers::v1::ListContainersRequest, ::containerd::services::containers::v1::ListContainerMessage>* streamer) {
                       return this->StreamedListStream(context,
                         streamer);
                  }));
    }
    ~WithSplitStreamingMethod_ListStream() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListStream(::grpc::ServerContext* /*context*/, const ::containerd::services::containers::v1::ListContainersRequest* /*request*/, ::grpc::ServerWriter< ::containerd::services::containers::v1::ListContainerMessage>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with split streamed
    virtual ::grpc::Status StreamedListStream(::grpc::ServerContext* context, ::grpc::ServerSplitStreamer< ::containerd::services::containers::v1::ListContainersRequest,::containerd::services::containers::v1::ListContainerMessage>* server_split_streamer) = 0;
  };
  typedef WithSplitStreamingMethod_ListStream<Service > SplitStreamedService;
  typedef WithStreamedUnaryMethod_Get<WithStreamedUnaryMethod_List<WithSplitStreamingMethod_ListStream<WithStreamedUnaryMethod_Create<WithStreamedUnaryMethod_Update<WithStreamedUnaryMethod_Delete<Service > > > > > > StreamedService;
};

}  // namespace v1
}  // namespace containers
}  // namespace services
}  // namespace containerd


#include <grpcpp/ports_undef.inc>
#endif  // GRPC_containers_2eproto__INCLUDED
