/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.tidb.mysql.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDialect;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.utils.ArrayUtils;

public class TiDBDialect
extends MySQLDialect {
    public static final String[] TIDB_NON_TRANSACTIONAL_KEYWORDS = new String[]{"OPTIMISTIC", "PESSIMISTIC"};
    private static final String[] TIDB_ADVANCED_KEYWORDS = new String[]{"AUTO_RANDOM", "PLACEMENT", "POLICY", "REORGANIZE", "EXCHANGE", "CACHE", "NONCLUSTERED", "CLUSTERED"};
    private static final String[] TIDB_EXTRA_FUNCTIONS = new String[]{"TIDB_BOUNDED_STALENESS", "TIDB_DECODE_KEY", "TIDB_DECODE_PLAN", "TIDB_IS_DDL_OWNER", "TIDB_PARSE_TSO", "TIDB_VERSION", "TIDB_DECODE_SQL_DIGESTS", "TIDB_SHARD"};

    public TiDBDialect() {
        super("TiDB", "tidb");
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        String kw;
        super.initBaseDriverSettings(session, dataSource, metaData);
        String[] stringArray = TIDB_ADVANCED_KEYWORDS;
        int n = TIDB_ADVANCED_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            kw = stringArray[n2];
            this.addSQLKeyword(kw);
            ++n2;
        }
        stringArray = TIDB_NON_TRANSACTIONAL_KEYWORDS;
        n = TIDB_NON_TRANSACTIONAL_KEYWORDS.length;
        n2 = 0;
        while (n2 < n) {
            kw = stringArray[n2];
            this.addSQLKeyword(kw);
            ++n2;
        }
        this.addFunctions(Arrays.asList(TIDB_EXTRA_FUNCTIONS));
    }

    @NotNull
    public String[] getNonTransactionKeywords() {
        return (String[])ArrayUtils.concatArrays((Object[])MySQLDialect.MYSQL_NON_TRANSACTIONAL_KEYWORDS, (Object[])TIDB_NON_TRANSACTIONAL_KEYWORDS);
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return new String[0];
    }
}

