/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKeyColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableForeignKey;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;

public class MySQLTableForeignKey
extends JDBCTableForeignKey<MySQLTable, MySQLTableForeignKeyColumn, MySQLTableConstraint> {
    private List<MySQLTableForeignKeyColumn> columns;

    public MySQLTableForeignKey(MySQLTable table, String name, String remarks, MySQLTableConstraint referencedKey, DBSForeignKeyModifyRule deleteRule, DBSForeignKeyModifyRule updateRule, boolean persisted) {
        super((JDBCTable)table, name, remarks, (DBSEntityConstraint)referencedKey, deleteRule, updateRule, persisted);
    }

    public MySQLTableForeignKey(DBRProgressMonitor monitor, MySQLTable table, DBSEntityAssociation source) throws DBException {
        super(monitor, (JDBCTable)table, source, false);
        List columns;
        if (source instanceof DBSEntityReferrer && (columns = ((DBSEntityReferrer)source).getAttributeReferences(monitor)) != null) {
            this.columns = new ArrayList<MySQLTableForeignKeyColumn>(columns.size());
            for (DBSEntityAttributeRef srcCol : columns) {
                if (!(srcCol instanceof DBSTableForeignKeyColumn)) continue;
                DBSTableForeignKeyColumn fkCol = (DBSTableForeignKeyColumn)srcCol;
                this.columns.add(new MySQLTableForeignKeyColumn(this, table.getAttribute(monitor, fkCol.getName()), this.columns.size(), table.getAttribute(monitor, fkCol.getReferencedColumn().getName())));
            }
        }
    }

    public List<MySQLTableForeignKeyColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        return this.columns;
    }

    public void setAttributeReferences(List<MySQLTableForeignKeyColumn> columns) throws DBException {
        this.columns = columns;
    }

    @Property(viewable=true, editable=true, updatable=true, listProvider=JDBCTableForeignKey.ConstraintModifyRuleListProvider.class, order=5)
    @NotNull
    public DBSForeignKeyModifyRule getDeleteRule() {
        return super.getDeleteRule();
    }

    @Property(viewable=true, editable=true, updatable=true, listProvider=JDBCTableForeignKey.ConstraintModifyRuleListProvider.class, order=6)
    @NotNull
    public DBSForeignKeyModifyRule getUpdateRule() {
        return super.getUpdateRule();
    }

    public void addColumn(MySQLTableForeignKeyColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<MySQLTableForeignKeyColumn>();
        }
        this.columns.add(column);
    }

    public boolean hasColumn(MySQLTableForeignKeyColumn column) {
        if (this.columns != null) {
            String columnName = column.getName();
            String refName = column.getReferencedColumn().getName();
            for (MySQLTableForeignKeyColumn col : this.columns) {
                if (!columnName.equals(col.getName()) || !refName.equals(col.getReferencedColumn().getName())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((MySQLTable)this.getTable()).getContainer(), this.getTable(), this});
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return (MySQLDataSource)((MySQLTable)this.getTable()).getDataSource();
    }
}

