/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2SourceObject;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.DB2ViewBaseDep;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2ViewBaseDepCache;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2ViewStatus;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.CommonUtils;

public abstract class DB2ViewBase
extends DB2TableBase
implements DB2SourceObject,
DBSView {
    protected final DB2ViewBaseDepCache viewBaseDepCache = new DB2ViewBaseDepCache();
    private Timestamp alterTime;
    private Timestamp invalidateTime;
    private Timestamp lastRegenTime;
    private DB2ViewStatus valid;
    private String text;
    private String funcPath;

    public DB2ViewBase(DBRProgressMonitor monitor, DB2Schema schema, ResultSet dbResult) {
        super(monitor, schema, dbResult);
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABNAME"));
        this.valid = (DB2ViewStatus)CommonUtils.valueOf(DB2ViewStatus.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALID"));
        this.text = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TEXT");
        this.funcPath = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FUNC_PATH");
        this.invalidateTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"INVALIDATE_TIME");
        this.lastRegenTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REGEN_TIME");
        if (((DB2DataSource)this.getDataSource()).isAtLeastV9_5()) {
            this.alterTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ALTER_TIME");
        }
    }

    public boolean isView() {
        return true;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid.getState();
    }

    @Override
    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.viewBaseDepCache.clearCache();
        return this;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return SQLFormatUtils.formatSQL((DBPDataSource)this.getDataSource(), (String)this.text);
    }

    @Association
    public Collection<DB2ViewBaseDep> getViewDeps(DBRProgressMonitor monitor) throws DBException {
        return this.viewBaseDepCache.getAllObjects(monitor, this);
    }

    @Override
    @Property(viewable=false, editable=false, updatable=false, length=PropertyLength.MULTILINE)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=false, order=20)
    public DB2ViewStatus getValid() {
        return this.valid;
    }

    @Property(viewable=false, editable=false, order=20)
    public String getFuncPath() {
        return this.funcPath;
    }

    @Property(viewable=false, editable=false, order=101, category="Date & Time")
    public Timestamp getAlterTime() {
        return this.alterTime;
    }

    @Property(viewable=false, editable=false, order=102, category="Date & Time")
    public Timestamp getInvalidateTime() {
        return this.invalidateTime;
    }

    @Property(viewable=false, editable=false, order=103, category="Date & Time")
    public Timestamp getLastRegenTime() {
        return this.lastRegenTime;
    }
}

