"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IterableBackoff = void 0;
class IterableBackoff {
    /**
     * Backoff that returns a number from an iterable.
     */
    constructor(durations) {
        this.durations = durations;
    }
    /**
     * @inheritdoc
     */
    next(_context) {
        return instance(this.durations, 0);
    }
}
exports.IterableBackoff = IterableBackoff;
const instance = (durations, index) => ({
    duration: durations[index],
    next() {
        return index === durations.length - 1 ? this : instance(durations, index + 1);
    },
});//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/2901c5ac6db8a986a5666c3af51ff804d05af0d4/node_modules/cockatiel/dist/backoff/IterableBackoff.js.map