﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/mediapackage/MediaPackage_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mediapackage/model/OriginEndpoint.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace MediaPackage
{
namespace Model
{
  class ListOriginEndpointsResult
  {
  public:
    AWS_MEDIAPACKAGE_API ListOriginEndpointsResult() = default;
    AWS_MEDIAPACKAGE_API ListOriginEndpointsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_MEDIAPACKAGE_API ListOriginEndpointsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * A token that can be used to resume pagination from the end of the collection.
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    ListOriginEndpointsResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * A list of OriginEndpoint records.
     */
    inline const Aws::Vector<OriginEndpoint>& GetOriginEndpoints() const { return m_originEndpoints; }
    template<typename OriginEndpointsT = Aws::Vector<OriginEndpoint>>
    void SetOriginEndpoints(OriginEndpointsT&& value) { m_originEndpointsHasBeenSet = true; m_originEndpoints = std::forward<OriginEndpointsT>(value); }
    template<typename OriginEndpointsT = Aws::Vector<OriginEndpoint>>
    ListOriginEndpointsResult& WithOriginEndpoints(OriginEndpointsT&& value) { SetOriginEndpoints(std::forward<OriginEndpointsT>(value)); return *this;}
    template<typename OriginEndpointsT = OriginEndpoint>
    ListOriginEndpointsResult& AddOriginEndpoints(OriginEndpointsT&& value) { m_originEndpointsHasBeenSet = true; m_originEndpoints.emplace_back(std::forward<OriginEndpointsT>(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    ListOriginEndpointsResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::Vector<OriginEndpoint> m_originEndpoints;
    bool m_originEndpointsHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace MediaPackage
} // namespace Aws
