﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/appsync/AppSyncRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/appsync/model/SourceApiAssociationConfig.h>
#include <utility>

namespace Aws
{
namespace AppSync
{
namespace Model
{

  /**
   */
  class AssociateSourceGraphqlApiRequest : public AppSyncRequest
  {
  public:
    AWS_APPSYNC_API AssociateSourceGraphqlApiRequest() = default;

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "AssociateSourceGraphqlApi"; }

    AWS_APPSYNC_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline const Aws::String& GetMergedApiIdentifier() const { return m_mergedApiIdentifier; }
    inline bool MergedApiIdentifierHasBeenSet() const { return m_mergedApiIdentifierHasBeenSet; }
    template<typename MergedApiIdentifierT = Aws::String>
    void SetMergedApiIdentifier(MergedApiIdentifierT&& value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier = std::forward<MergedApiIdentifierT>(value); }
    template<typename MergedApiIdentifierT = Aws::String>
    AssociateSourceGraphqlApiRequest& WithMergedApiIdentifier(MergedApiIdentifierT&& value) { SetMergedApiIdentifier(std::forward<MergedApiIdentifierT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The identifier of the AppSync Source API. This is generated by the AppSync
     * service. In most cases, source APIs (especially in your account) only require
     * the API ID value or ARN of the source API. However, source APIs from other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * source API.</p>
     */
    inline const Aws::String& GetSourceApiIdentifier() const { return m_sourceApiIdentifier; }
    inline bool SourceApiIdentifierHasBeenSet() const { return m_sourceApiIdentifierHasBeenSet; }
    template<typename SourceApiIdentifierT = Aws::String>
    void SetSourceApiIdentifier(SourceApiIdentifierT&& value) { m_sourceApiIdentifierHasBeenSet = true; m_sourceApiIdentifier = std::forward<SourceApiIdentifierT>(value); }
    template<typename SourceApiIdentifierT = Aws::String>
    AssociateSourceGraphqlApiRequest& WithSourceApiIdentifier(SourceApiIdentifierT&& value) { SetSourceApiIdentifier(std::forward<SourceApiIdentifierT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The description field.</p>
     */
    inline const Aws::String& GetDescription() const { return m_description; }
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
    template<typename DescriptionT = Aws::String>
    void SetDescription(DescriptionT&& value) { m_descriptionHasBeenSet = true; m_description = std::forward<DescriptionT>(value); }
    template<typename DescriptionT = Aws::String>
    AssociateSourceGraphqlApiRequest& WithDescription(DescriptionT&& value) { SetDescription(std::forward<DescriptionT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline const SourceApiAssociationConfig& GetSourceApiAssociationConfig() const { return m_sourceApiAssociationConfig; }
    inline bool SourceApiAssociationConfigHasBeenSet() const { return m_sourceApiAssociationConfigHasBeenSet; }
    template<typename SourceApiAssociationConfigT = SourceApiAssociationConfig>
    void SetSourceApiAssociationConfig(SourceApiAssociationConfigT&& value) { m_sourceApiAssociationConfigHasBeenSet = true; m_sourceApiAssociationConfig = std::forward<SourceApiAssociationConfigT>(value); }
    template<typename SourceApiAssociationConfigT = SourceApiAssociationConfig>
    AssociateSourceGraphqlApiRequest& WithSourceApiAssociationConfig(SourceApiAssociationConfigT&& value) { SetSourceApiAssociationConfig(std::forward<SourceApiAssociationConfigT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_mergedApiIdentifier;
    bool m_mergedApiIdentifierHasBeenSet = false;

    Aws::String m_sourceApiIdentifier;
    bool m_sourceApiIdentifierHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;

    SourceApiAssociationConfig m_sourceApiAssociationConfig;
    bool m_sourceApiAssociationConfigHasBeenSet = false;
  };

} // namespace Model
} // namespace AppSync
} // namespace Aws
