import { Measurement, getV8Flags, mongoMeasurement } from '@codspeed/core';
import { join } from 'path';

const __dirname = new URL(".", import.meta.url).pathname;
const isFileInTs = import.meta.url.endsWith(".ts");
function getCodSpeedFileFromName(name) {
  const fileExtension = isFileInTs ? "ts" : "mjs";
  return join(__dirname, `${name}.${fileExtension}`);
}
function codspeedPlugin() {
  return {
    name: "codspeed:vitest",
    apply(_, { mode }) {
      if (mode !== "benchmark") {
        return false;
      }
      if (!Measurement.isInstrumented()) {
        console.warn("[CodSpeed] bench detected but no instrumentation found");
      }
      return true;
    },
    enforce: "post",
    config() {
      return {
        test: {
          pool: "forks",
          poolOptions: {
            forks: {
              execArgv: getV8Flags()
            }
          },
          runner: getCodSpeedFileFromName("runner"),
          globalSetup: [getCodSpeedFileFromName("globalSetup")]
        }
      };
    }
  };
}
async function setupInstruments(body) {
  if (!Measurement.isInstrumented()) {
    console.warn("[CodSpeed] No instrumentation found, using default mongoUrl");
    return { remoteAddr: body.mongoUrl };
  }
  return await mongoMeasurement.setupInstruments(body);
}

export { codspeedPlugin as default, setupInstruments };
