//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceStorm;

/**
 * Publishers publish information on a particular topic. A topic
 * logically represents a type.
 *
 * @see TopicManager
 **/
public interface Topic extends com.zeroc.Ice.Object
{
    /**
     * Get the name of this topic.
     * @param current The Current object for the invocation.
     * @return The name of the topic.
     *
     * @see TopicManager#create
     **/
    String getName(com.zeroc.Ice.Current current);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls getPublisher and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     * @param current The Current object for the invocation.
     * @return A proxy to publish data on this topic.
     **/
    com.zeroc.Ice.ObjectPrx getPublisher(com.zeroc.Ice.Current current);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * getPublisher and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     * @param current The Current object for the invocation.
     * @return A proxy to publish data on this topic.
     **/
    com.zeroc.Ice.ObjectPrx getNonReplicatedPublisher(com.zeroc.Ice.Current current);

    /**
     * Subscribe with the given <code>qos</code> to this topic.  A
     * per-subscriber publisher object is returned.
     * @param theQoS The quality of service parameters for this
     * subscription.
     * @param subscriber The subscriber's proxy.
     * @param current The Current object for the invocation.
     * @return The per-subscriber publisher object.
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     * @throws InvalidSubscriber Raised if the subscriber object is null.
     *
     * @see #unsubscribe
     **/
    com.zeroc.Ice.ObjectPrx subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, com.zeroc.Ice.ObjectPrx subscriber, com.zeroc.Ice.Current current)
        throws AlreadySubscribed,
               BadQoS,
               InvalidSubscriber;

    /**
     * Unsubscribe the given <code>subscriber</code>.
     * @param subscriber The proxy of an existing subscriber.
     * @param current The Current object for the invocation.
     *
     * @see #subscribeAndGetPublisher
     **/
    void unsubscribe(com.zeroc.Ice.ObjectPrx subscriber, com.zeroc.Ice.Current current);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <code>linkTo</code>.
     * @param linkTo The topic to link to.
     * @param cost The cost to the linked topic.
     * @param current The Current object for the invocation.
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     **/
    void link(TopicPrx linkTo, int cost, com.zeroc.Ice.Current current)
        throws LinkExists;

    /**
     * Destroy the link from this topic to the given topic <code>linkTo</code>.
     * @param linkTo The topic to destroy the link to.
     * @param current The Current object for the invocation.
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     **/
    void unlink(TopicPrx linkTo, com.zeroc.Ice.Current current)
        throws NoSuchLink;

    /**
     * Retrieve information on the current links.
     * @param current The Current object for the invocation.
     * @return A sequence of LinkInfo objects.
     **/
    LinkInfo[] getLinkInfoSeq(com.zeroc.Ice.Current current);

    /**
     * Retrieve the list of subscribers for this topic.
     * @param current The Current object for the invocation.
     * @return The sequence of Ice identities for the subscriber objects.
     **/
    com.zeroc.Ice.Identity[] getSubscribers(com.zeroc.Ice.Current current);

    /**
     * Destroy the topic.
     * @param current The Current object for the invocation.
     **/
    void destroy(com.zeroc.Ice.Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::IceStorm::Topic"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceStorm::Topic";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getName(Topic obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String ret = obj.getName(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getPublisher(Topic obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        com.zeroc.Ice.ObjectPrx ret = obj.getPublisher(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getNonReplicatedPublisher(Topic obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        com.zeroc.Ice.ObjectPrx ret = obj.getNonReplicatedPublisher(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_subscribeAndGetPublisher(Topic obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        java.util.Map<java.lang.String, java.lang.String> iceP_theQoS;
        com.zeroc.Ice.ObjectPrx iceP_subscriber;
        iceP_theQoS = QoSHelper.read(istr);
        iceP_subscriber = istr.readProxy();
        inS.endReadParams();
        com.zeroc.Ice.ObjectPrx ret = obj.subscribeAndGetPublisher(iceP_theQoS, iceP_subscriber, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_unsubscribe(Topic obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.ObjectPrx iceP_subscriber;
        iceP_subscriber = istr.readProxy();
        inS.endReadParams();
        obj.unsubscribe(iceP_subscriber, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_link(Topic obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        TopicPrx iceP_linkTo;
        int iceP_cost;
        iceP_linkTo = TopicPrx.uncheckedCast(istr.readProxy());
        iceP_cost = istr.readInt();
        inS.endReadParams();
        obj.link(iceP_linkTo, iceP_cost, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_unlink(Topic obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        TopicPrx iceP_linkTo;
        iceP_linkTo = TopicPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        obj.unlink(iceP_linkTo, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getLinkInfoSeq(Topic obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        LinkInfo[] ret = obj.getLinkInfoSeq(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        LinkInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getSubscribers(Topic obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        com.zeroc.Ice.Identity[] ret = obj.getSubscribers(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        com.zeroc.Ice.IdentitySeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_destroy(Topic obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.destroy(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "destroy",
        "getLinkInfoSeq",
        "getName",
        "getNonReplicatedPublisher",
        "getPublisher",
        "getSubscribers",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "link",
        "subscribeAndGetPublisher",
        "unlink",
        "unsubscribe"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_destroy(this, in, current);
            }
            case 1:
            {
                return _iceD_getLinkInfoSeq(this, in, current);
            }
            case 2:
            {
                return _iceD_getName(this, in, current);
            }
            case 3:
            {
                return _iceD_getNonReplicatedPublisher(this, in, current);
            }
            case 4:
            {
                return _iceD_getPublisher(this, in, current);
            }
            case 5:
            {
                return _iceD_getSubscribers(this, in, current);
            }
            case 6:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 7:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 8:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 9:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
            case 10:
            {
                return _iceD_link(this, in, current);
            }
            case 11:
            {
                return _iceD_subscribeAndGetPublisher(this, in, current);
            }
            case 12:
            {
                return _iceD_unlink(this, in, current);
            }
            case 13:
            {
                return _iceD_unsubscribe(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
