/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.EffectUtil;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.prism.Graphics;
import com.sun.prism.RectShadowGraphics;
import com.sun.prism.paint.Color;
import com.sun.prism.shape.ShapeRep;
import com.sun.scenario.effect.Effect;

public class NGRectangle
extends NGShape {
    private RoundRectangle2D rrect = new RoundRectangle2D();
    private static final double SQRT_2 = Math.sqrt(2.0);

    public void updateRectangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.rrect.x = f;
        this.rrect.y = f2;
        this.rrect.width = f3;
        this.rrect.height = f4;
        this.rrect.arcWidth = f5;
        this.rrect.arcHeight = f6;
        this.geometryChanged();
    }

    @Override
    protected boolean supportsOpaqueRegions() {
        return true;
    }

    @Override
    protected boolean hasOpaqueRegion() {
        return super.hasOpaqueRegion() && this.rrect.width > 1.0f && this.rrect.height > 1.0f;
    }

    @Override
    protected RectBounds computeOpaqueRegion(RectBounds rectBounds) {
        float f = this.rrect.x;
        float f2 = this.rrect.y;
        float f3 = this.rrect.width;
        float f4 = this.rrect.height;
        float f5 = this.rrect.arcWidth;
        float f6 = this.rrect.arcHeight;
        if (f5 <= 0.0f || f6 <= 0.0f) {
            return (RectBounds)rectBounds.deriveWithNewBounds(f, f2, 0.0f, f + f3, f2 + f4, 0.0f);
        }
        float f7 = Math.min(f3, f5) * 0.14700001f;
        float f8 = Math.min(f4, f6) * 0.14700001f;
        return (RectBounds)rectBounds.deriveWithNewBounds(f + f7, f2 + f8, 0.0f, f + f3 - f7, f2 + f4 - f8, 0.0f);
    }

    boolean isRounded() {
        return this.rrect.arcWidth > 0.0f && this.rrect.arcHeight > 0.0f;
    }

    @Override
    protected void renderEffect(Graphics graphics) {
        if (!(graphics instanceof RectShadowGraphics) || !this.renderEffectDirectly(graphics)) {
            super.renderEffect(graphics);
        }
    }

    private boolean renderEffectDirectly(Graphics graphics) {
        if (this.mode != NGShape.Mode.FILL || this.isRounded()) {
            return false;
        }
        float f = graphics.getExtraAlpha();
        if (!(this.fillPaint instanceof Color)) {
            return false;
        }
        Effect effect = this.getEffect();
        return EffectUtil.renderEffectForRectangularNode(this, graphics, effect, f *= ((Color)this.fillPaint).getAlpha(), true, this.rrect.x, this.rrect.y, this.rrect.width, this.rrect.height);
    }

    @Override
    public final Shape getShape() {
        return this.rrect;
    }

    @Override
    protected ShapeRep createShapeRep(Graphics graphics) {
        return graphics.getResourceFactory().createRoundRectRep();
    }

    @Override
    protected final boolean isRectClip(BaseTransform baseTransform, boolean bl) {
        long l;
        if (this.mode != NGShape.Mode.FILL || this.getClipNode() != null || this.getEffect() != null && this.getEffect().reducesOpaquePixels() || this.getOpacity() < 1.0f || !bl && this.isRounded() || !this.fillPaint.isOpaque()) {
            return false;
        }
        BaseTransform baseTransform2 = this.getTransform();
        if (!baseTransform2.isIdentity()) {
            if (!baseTransform.isIdentity()) {
                TEMP_TRANSFORM.setTransform(baseTransform);
                TEMP_TRANSFORM.concatenate(baseTransform2);
                baseTransform = TEMP_TRANSFORM;
            } else {
                baseTransform = baseTransform2;
            }
        }
        return ((l = (long)baseTransform.getType()) & 0xFFFFFFFFFFFFFFF0L) == 0L;
    }
}

