/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.tomcat.dbcp.pool2.DestroyMode;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PoolUtils;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObjectState;
import org.apache.tomcat.dbcp.pool2.UsageTracking;
import org.apache.tomcat.dbcp.pool2.impl.AbandonedConfig;
import org.apache.tomcat.dbcp.pool2.impl.BaseGenericObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObjectInfo;
import org.apache.tomcat.dbcp.pool2.impl.EvictionConfig;
import org.apache.tomcat.dbcp.pool2.impl.EvictionPolicy;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPoolMXBean;
import org.apache.tomcat.dbcp.pool2.impl.LinkedBlockingDeque;
import org.apache.tomcat.dbcp.pool2.impl.PoolImplUtils;

public class GenericObjectPool<T>
extends BaseGenericObjectPool<T>
implements ObjectPool<T>,
GenericObjectPoolMXBean,
UsageTracking<T> {
    private static final String ONAME_BASE = "org.apache.commons.pool2:type=GenericObjectPool,name=";
    private volatile String factoryType;
    private volatile int maxIdle = 8;
    private volatile int minIdle = 0;
    private final PooledObjectFactory<T> factory;
    private final ConcurrentHashMap<BaseGenericObjectPool.IdentityWrapper<T>, PooledObject<T>> allObjects = new ConcurrentHashMap();
    private final AtomicLong createCount = new AtomicLong();
    private long makeObjectCount;
    private final Object makeObjectCountLock = new Object();
    private final LinkedBlockingDeque<PooledObject<T>> idleObjects;

    private static void wait(Object object, Duration duration) throws InterruptedException {
        if (!duration.isNegative()) {
            object.wait(duration.toMillis(), duration.getNano() % 1000000);
        }
    }

    public GenericObjectPool(PooledObjectFactory<T> pooledObjectFactory) {
        this(pooledObjectFactory, new GenericObjectPoolConfig());
    }

    public GenericObjectPool(PooledObjectFactory<T> pooledObjectFactory, GenericObjectPoolConfig<T> genericObjectPoolConfig) {
        super(genericObjectPoolConfig, ONAME_BASE, genericObjectPoolConfig.getJmxNamePrefix());
        if (pooledObjectFactory == null) {
            this.jmxUnregister();
            throw new IllegalArgumentException("Factory may not be null");
        }
        this.factory = pooledObjectFactory;
        this.idleObjects = new LinkedBlockingDeque(genericObjectPoolConfig.getFairness());
        this.setConfig(genericObjectPoolConfig);
    }

    public GenericObjectPool(PooledObjectFactory<T> pooledObjectFactory, GenericObjectPoolConfig<T> genericObjectPoolConfig, AbandonedConfig abandonedConfig) {
        this(pooledObjectFactory, genericObjectPoolConfig);
        this.setAbandonedConfig(abandonedConfig);
    }

    private void addIdleObject(PooledObject<T> pooledObject) throws Exception {
        if (!PooledObject.isNull(pooledObject)) {
            this.factory.passivateObject(pooledObject);
            if (this.getLifo()) {
                this.idleObjects.addFirst(pooledObject);
            } else {
                this.idleObjects.addLast(pooledObject);
            }
        }
    }

    @Override
    public void addObject() throws Exception {
        this.assertOpen();
        if (this.factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        this.addIdleObject(this.create(this.getMaxWaitDuration()));
    }

    @Override
    public T borrowObject() throws Exception {
        return this.borrowObject(this.getMaxWaitDuration());
    }

    public T borrowObject(Duration duration) throws Exception {
        this.assertOpen();
        Instant instant = Instant.now();
        boolean bl = duration.isNegative();
        Duration duration2 = duration;
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        if (abandonedConfig != null && abandonedConfig.getRemoveAbandonedOnBorrow() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxTotal() - 3) {
            this.removeAbandoned(abandonedConfig);
        }
        PooledObject<T> pooledObject = null;
        boolean bl2 = this.getBlockWhenExhausted();
        while (pooledObject == null) {
            Throwable throwable;
            boolean bl3;
            block17: {
                duration2 = duration2.minus(this.durationSince(instant));
                bl3 = false;
                pooledObject = this.idleObjects.pollFirst();
                if (pooledObject == null && !PooledObject.isNull(pooledObject = this.create(duration2))) {
                    bl3 = true;
                }
                if (bl2) {
                    if (PooledObject.isNull(pooledObject)) {
                        PooledObject<T> pooledObject2 = pooledObject = bl ? this.idleObjects.takeFirst() : this.idleObjects.pollFirst(duration2);
                    }
                    if (PooledObject.isNull(pooledObject)) {
                        throw new NoSuchElementException(this.appendStats("Timeout waiting for idle object, borrowMaxWaitDuration=" + String.valueOf(duration2)));
                    }
                } else if (PooledObject.isNull(pooledObject)) {
                    throw new NoSuchElementException(this.appendStats("Pool exhausted"));
                }
                if (!pooledObject.allocate()) {
                    pooledObject = null;
                }
                if (PooledObject.isNull(pooledObject)) continue;
                try {
                    this.factory.activateObject(pooledObject);
                }
                catch (Exception exception) {
                    try {
                        this.destroy(pooledObject, DestroyMode.NORMAL);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    pooledObject = null;
                    if (!bl3) break block17;
                    throwable = new NoSuchElementException(this.appendStats("Unable to activate object"));
                    throwable.initCause(exception);
                    throw throwable;
                }
            }
            if (PooledObject.isNull(pooledObject) || !this.getTestOnBorrow()) continue;
            boolean bl4 = false;
            throwable = null;
            try {
                bl4 = this.factory.validateObject(pooledObject);
            }
            catch (Throwable throwable2) {
                PoolUtils.checkRethrow(throwable2);
                throwable = throwable2;
            }
            if (bl4) continue;
            try {
                this.destroy(pooledObject, DestroyMode.NORMAL);
                this.destroyedByBorrowValidationCount.incrementAndGet();
            }
            catch (Exception exception) {
                // empty catch block
            }
            pooledObject = null;
            if (!bl3) continue;
            NoSuchElementException noSuchElementException = new NoSuchElementException(this.appendStats("Unable to validate object"));
            noSuchElementException.initCause(throwable);
            throw noSuchElementException;
        }
        this.updateStatsBorrow(pooledObject, this.durationSince(instant));
        return pooledObject.getObject();
    }

    private Duration durationSince(Instant instant) {
        return Duration.between(instant, Instant.now());
    }

    public T borrowObject(long l) throws Exception {
        return this.borrowObject(Duration.ofMillis(l));
    }

    @Override
    public void clear() {
        PooledObject<T> pooledObject = this.idleObjects.poll();
        while (pooledObject != null) {
            try {
                this.destroy(pooledObject, DestroyMode.NORMAL);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
            pooledObject = this.idleObjects.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.stopEvictor();
            this.closed = true;
            this.clear();
            this.jmxUnregister();
            this.idleObjects.interuptTakeWaiters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledObject<T> create(Duration duration) throws Exception {
        Object object;
        Instant instant = Instant.now();
        Duration duration2 = duration.isNegative() ? Duration.ZERO : duration;
        int n = this.getMaxTotal();
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        Instant instant2 = Instant.now();
        Boolean bl = null;
        while (bl == null) {
            duration2 = duration2.minus(this.durationSince(instant));
            object = this.makeObjectCountLock;
            synchronized (object) {
                long l = this.createCount.incrementAndGet();
                if (l > (long)n) {
                    this.createCount.decrementAndGet();
                    if (this.makeObjectCount == 0L) {
                        bl = Boolean.FALSE;
                    } else {
                        GenericObjectPool.wait(this.makeObjectCountLock, duration2);
                    }
                } else {
                    ++this.makeObjectCount;
                    bl = Boolean.TRUE;
                }
            }
            if (bl != null || duration2.compareTo(Duration.ZERO) <= 0 || this.durationSince(instant2).compareTo(duration2) < 0) continue;
            bl = Boolean.FALSE;
        }
        if (!bl.booleanValue()) {
            return null;
        }
        try {
            object = this.factory.makeObject();
            if (PooledObject.isNull(object)) {
                this.createCount.decrementAndGet();
                throw new NullPointerException(String.format("%s.makeObject() = null", this.factory.getClass().getSimpleName()));
            }
            if (this.getTestOnCreate() && !this.factory.validateObject((PooledObject<T>)object)) {
                this.createCount.decrementAndGet();
                PooledObject<T> pooledObject = null;
                return pooledObject;
            }
        }
        catch (Throwable throwable) {
            this.createCount.decrementAndGet();
            throw throwable;
        }
        finally {
            Object object2 = this.makeObjectCountLock;
            synchronized (object2) {
                --this.makeObjectCount;
                this.makeObjectCountLock.notifyAll();
            }
        }
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        if (abandonedConfig != null && abandonedConfig.getLogAbandoned()) {
            object.setLogAbandoned(true);
            object.setRequireFullStackTrace(abandonedConfig.getRequireFullStackTrace());
        }
        this.createdCount.incrementAndGet();
        this.allObjects.put(new BaseGenericObjectPool.IdentityWrapper(object.getObject()), (PooledObject<T>)object);
        return object;
    }

    private void destroy(PooledObject<T> pooledObject, DestroyMode destroyMode) throws Exception {
        pooledObject.invalidate();
        this.idleObjects.remove(pooledObject);
        this.allObjects.remove(new BaseGenericObjectPool.IdentityWrapper<T>(pooledObject.getObject()));
        try {
            this.factory.destroyObject(pooledObject, destroyMode);
        }
        finally {
            this.destroyedCount.incrementAndGet();
            this.createCount.decrementAndGet();
        }
    }

    private void ensureIdle(int n, boolean bl) throws Exception {
        PooledObject<T> pooledObject;
        if (n < 1 || this.isClosed() || !bl && !this.idleObjects.hasTakeWaiters()) {
            return;
        }
        while (this.idleObjects.size() < n && !PooledObject.isNull(pooledObject = this.create(this.getMaxWaitDuration()))) {
            if (this.getLifo()) {
                this.idleObjects.addFirst(pooledObject);
                continue;
            }
            this.idleObjects.addLast(pooledObject);
        }
        if (this.isClosed()) {
            this.clear();
        }
    }

    @Override
    void ensureMinIdle() throws Exception {
        this.ensureIdle(this.getMinIdle(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict() throws Exception {
        Object object;
        this.assertOpen();
        if (!this.idleObjects.isEmpty()) {
            object = null;
            EvictionPolicy evictionPolicy = this.getEvictionPolicy();
            Object object2 = this.evictionLock;
            synchronized (object2) {
                EvictionConfig evictionConfig = new EvictionConfig(this.getMinEvictableIdleDuration(), this.getSoftMinEvictableIdleDuration(), this.getMinIdle());
                boolean bl = this.getTestWhileIdle();
                int n = this.getNumTests();
                for (int i = 0; i < n; ++i) {
                    boolean bl2;
                    if (this.evictionIterator == null || !this.evictionIterator.hasNext()) {
                        this.evictionIterator = new BaseGenericObjectPool.EvictionIterator(this.idleObjects);
                    }
                    if (!this.evictionIterator.hasNext()) {
                        return;
                    }
                    try {
                        object = this.evictionIterator.next();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        --i;
                        this.evictionIterator = null;
                        continue;
                    }
                    if (!object.startEvictionTest()) {
                        --i;
                        continue;
                    }
                    try {
                        bl2 = evictionPolicy.evict(evictionConfig, object, this.idleObjects.size());
                    }
                    catch (Throwable throwable) {
                        PoolUtils.checkRethrow(throwable);
                        this.swallowException(new Exception(throwable));
                        bl2 = false;
                    }
                    if (bl2) {
                        this.destroy((PooledObject<T>)object, DestroyMode.NORMAL);
                        this.destroyedByEvictorCount.incrementAndGet();
                        continue;
                    }
                    if (bl) {
                        boolean bl3 = false;
                        try {
                            this.factory.activateObject((PooledObject<T>)object);
                            bl3 = true;
                        }
                        catch (Exception exception) {
                            this.destroy((PooledObject<T>)object, DestroyMode.NORMAL);
                            this.destroyedByEvictorCount.incrementAndGet();
                        }
                        if (bl3) {
                            boolean bl4 = false;
                            Throwable throwable = null;
                            try {
                                bl4 = this.factory.validateObject((PooledObject<T>)object);
                            }
                            catch (Throwable throwable2) {
                                PoolUtils.checkRethrow(throwable2);
                                throwable = throwable2;
                            }
                            if (!bl4) {
                                this.destroy((PooledObject<T>)object, DestroyMode.NORMAL);
                                this.destroyedByEvictorCount.incrementAndGet();
                                if (throwable != null) {
                                    if (throwable instanceof RuntimeException) {
                                        throw (RuntimeException)throwable;
                                    }
                                    throw (Error)throwable;
                                }
                            } else {
                                try {
                                    this.factory.passivateObject((PooledObject<T>)object);
                                }
                                catch (Exception exception) {
                                    this.destroy((PooledObject<T>)object, DestroyMode.NORMAL);
                                    this.destroyedByEvictorCount.incrementAndGet();
                                }
                            }
                        }
                    }
                    object.endEvictionTest(this.idleObjects);
                }
            }
        }
        if ((object = this.abandonedConfig) != null && ((AbandonedConfig)object).getRemoveAbandonedOnMaintenance()) {
            this.removeAbandoned((AbandonedConfig)object);
        }
    }

    public PooledObjectFactory<T> getFactory() {
        return this.factory;
    }

    @Override
    public String getFactoryType() {
        if (this.factoryType == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.factory.getClass().getName());
            stringBuilder.append('<');
            Class<?> clazz = PoolImplUtils.getFactoryType(this.factory.getClass());
            stringBuilder.append(clazz.getName());
            stringBuilder.append('>');
            this.factoryType = stringBuilder.toString();
        }
        return this.factoryType;
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public int getMinIdle() {
        int n = this.getMaxIdle();
        return Math.min(this.minIdle, n);
    }

    @Override
    public int getNumActive() {
        return this.allObjects.size() - this.idleObjects.size();
    }

    @Override
    public int getNumIdle() {
        return this.idleObjects.size();
    }

    private int getNumTests() {
        int n = this.getNumTestsPerEvictionRun();
        if (n >= 0) {
            return Math.min(n, this.idleObjects.size());
        }
        return (int)Math.ceil((double)this.idleObjects.size() / Math.abs((double)n));
    }

    @Override
    public int getNumWaiters() {
        if (this.getBlockWhenExhausted()) {
            return this.idleObjects.getTakeQueueLength();
        }
        return 0;
    }

    PooledObject<T> getPooledObject(T t) {
        return this.allObjects.get(new BaseGenericObjectPool.IdentityWrapper<T>(t));
    }

    @Override
    String getStatsString() {
        return super.getStatsString() + String.format(", createdCount=%,d, makeObjectCount=%,d, maxIdle=%,d, minIdle=%,d", this.createdCount.get(), this.makeObjectCount, this.maxIdle, this.minIdle);
    }

    @Override
    public void invalidateObject(T t) throws Exception {
        this.invalidateObject(t, DestroyMode.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(T t, DestroyMode destroyMode) throws Exception {
        PooledObject<T> pooledObject = this.getPooledObject(t);
        if (pooledObject == null) {
            if (this.isAbandonedConfig()) {
                return;
            }
            throw new IllegalStateException("Invalidated object not currently part of this pool");
        }
        PooledObject<T> pooledObject2 = pooledObject;
        synchronized (pooledObject2) {
            if (pooledObject.getState() != PooledObjectState.INVALID) {
                this.destroy(pooledObject, destroyMode);
            }
        }
        this.ensureIdle(1, false);
    }

    @Override
    public Set<DefaultPooledObjectInfo> listAllObjects() {
        return this.allObjects.values().stream().map(DefaultPooledObjectInfo::new).collect(Collectors.toSet());
    }

    public void preparePool() throws Exception {
        if (this.getMinIdle() < 1) {
            return;
        }
        this.ensureMinIdle();
    }

    private void removeAbandoned(AbandonedConfig abandonedConfig) {
        ArrayList<PooledObject<T>> arrayList = this.createRemoveList(abandonedConfig, this.allObjects);
        arrayList.forEach((Consumer<PooledObject<T>>)((Consumer<PooledObject>)pooledObject -> {
            if (abandonedConfig.getLogAbandoned()) {
                pooledObject.printStackTrace(abandonedConfig.getLogWriter());
            }
            try {
                this.invalidateObject(pooledObject.getObject(), DestroyMode.ABANDONED);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
        }));
    }

    @Override
    public void returnObject(T t) {
        PooledObject<T> pooledObject = this.getPooledObject(t);
        if (pooledObject == null) {
            if (!this.isAbandonedConfig()) {
                throw new IllegalStateException("Returned object not currently part of this pool");
            }
            return;
        }
        this.markReturningState(pooledObject);
        Duration duration = pooledObject.getActiveDuration();
        if (this.getTestOnReturn() && !this.factory.validateObject(pooledObject)) {
            try {
                this.destroy(pooledObject, DestroyMode.NORMAL);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
            try {
                this.ensureIdle(1, false);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
            this.updateStatsReturn(duration);
            return;
        }
        try {
            this.factory.passivateObject(pooledObject);
        }
        catch (Exception exception) {
            this.swallowException(exception);
            try {
                this.destroy(pooledObject, DestroyMode.NORMAL);
            }
            catch (Exception exception2) {
                this.swallowException(exception2);
            }
            try {
                this.ensureIdle(1, false);
            }
            catch (Exception exception3) {
                this.swallowException(exception3);
            }
            this.updateStatsReturn(duration);
            return;
        }
        if (!pooledObject.deallocate()) {
            throw new IllegalStateException("Object has already been returned to this pool or is invalid");
        }
        int n = this.getMaxIdle();
        if (this.isClosed() || n > -1 && n <= this.idleObjects.size()) {
            try {
                this.destroy(pooledObject, DestroyMode.NORMAL);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
            try {
                this.ensureIdle(1, false);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
        } else {
            if (this.getLifo()) {
                this.idleObjects.addFirst(pooledObject);
            } else {
                this.idleObjects.addLast(pooledObject);
            }
            if (this.isClosed()) {
                this.clear();
            }
        }
        this.updateStatsReturn(duration);
    }

    @Override
    public void setConfig(GenericObjectPoolConfig<T> genericObjectPoolConfig) {
        super.setConfig(genericObjectPoolConfig);
        this.setMaxIdle(genericObjectPoolConfig.getMaxIdle());
        this.setMinIdle(genericObjectPoolConfig.getMinIdle());
        this.setMaxTotal(genericObjectPoolConfig.getMaxTotal());
    }

    public void setMaxIdle(int n) {
        this.maxIdle = n;
    }

    public void setMinIdle(int n) {
        this.minIdle = n;
    }

    @Override
    protected void toStringAppendFields(StringBuilder stringBuilder) {
        super.toStringAppendFields(stringBuilder);
        stringBuilder.append(", factoryType=");
        stringBuilder.append(this.factoryType);
        stringBuilder.append(", maxIdle=");
        stringBuilder.append(this.maxIdle);
        stringBuilder.append(", minIdle=");
        stringBuilder.append(this.minIdle);
        stringBuilder.append(", factory=");
        stringBuilder.append(this.factory);
        stringBuilder.append(", allObjects=");
        stringBuilder.append(this.allObjects);
        stringBuilder.append(", createCount=");
        stringBuilder.append(this.createCount);
        stringBuilder.append(", idleObjects=");
        stringBuilder.append(this.idleObjects);
        stringBuilder.append(", abandonedConfig=");
        stringBuilder.append(this.abandonedConfig);
    }

    @Override
    public void use(T t) {
        PooledObject<T> pooledObject;
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        if (abandonedConfig != null && abandonedConfig.getUseUsageTracking() && (pooledObject = this.getPooledObject(t)) != null) {
            pooledObject.use();
        }
    }
}

