/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceLockSet;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractFileResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.http.RequestUtil;

public class DirResourceSet
extends AbstractFileResourceSet
implements WebResourceLockSet {
    private static final Log log = LogFactory.getLog(DirResourceSet.class);
    private final Map<String, WebResourceLockSet.ResourceLock> resourceLocksByPath = new HashMap<String, WebResourceLockSet.ResourceLock>();
    private final Object resourceLocksByPathLock = new Object();

    public DirResourceSet() {
        super("/");
    }

    public DirResourceSet(WebResourceRoot webResourceRoot, String string, String string2, String string3) {
        super(string3);
        this.setRoot(webResourceRoot);
        this.setWebAppMount(string);
        this.setBase(string2);
        if (webResourceRoot.getContext().getAddWebinfClassesResources()) {
            File file = new File(string2, string3);
            if ((file = new File(file, "/WEB-INF/classes/META-INF/resources")).isDirectory()) {
                webResourceRoot.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", file.getAbsolutePath(), null, "/");
            }
        }
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException lifecycleException) {
                throw new IllegalStateException(lifecycleException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResource getResource(String object) {
        this.checkPath((String)object);
        String string = this.getWebAppMount();
        WebResourceRoot webResourceRoot = this.getRoot();
        boolean bl = this.isReadOnly();
        if (((String)object).startsWith(string)) {
            WebResourceLockSet.ResourceLock resourceLock = bl ? null : this.lockForRead((String)object);
            try {
                File file = this.file(((String)object).substring(string.length()), false);
                if (file == null) {
                    EmptyResource emptyResource = new EmptyResource(webResourceRoot, (String)object);
                    return emptyResource;
                }
                if (!file.exists()) {
                    EmptyResource emptyResource = new EmptyResource(webResourceRoot, (String)object, file);
                    return emptyResource;
                }
                if (file.isDirectory() && ((String)object).charAt(((String)object).length() - 1) != '/') {
                    object = (String)object + "/";
                }
                FileResource fileResource = new FileResource(webResourceRoot, (String)object, file, bl, this.getManifest(), this, bl ? null : resourceLock.key);
                return fileResource;
            }
            finally {
                if (!bl) {
                    this.unlockForRead(resourceLock);
                }
            }
        }
        return new EmptyResource(webResourceRoot, (String)object);
    }

    @Override
    public String[] list(String object) {
        this.checkPath((String)object);
        String string = this.getWebAppMount();
        if (((String)object).startsWith(string)) {
            File file = this.file(((String)object).substring(string.length()), true);
            if (file == null) {
                return EMPTY_STRING_ARRAY;
            }
            String[] stringArray = file.list();
            return Objects.requireNonNullElse(stringArray, EMPTY_STRING_ARRAY);
        }
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        if (string.startsWith((String)object)) {
            int n = string.indexOf(47, ((String)object).length());
            if (n == -1) {
                return new String[]{string.substring(((String)object).length())};
            }
            return new String[]{string.substring(((String)object).length(), n)};
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> listWebAppPaths(String object) {
        this.checkPath((String)object);
        String string = this.getWebAppMount();
        ResourceSet<String> resourceSet = new ResourceSet<String>();
        if (((String)object).startsWith(string)) {
            File[] fileArray;
            File file = this.file(((String)object).substring(string.length()), true);
            if (file != null && (fileArray = file.listFiles()) != null) {
                for (File file2 : fileArray) {
                    if (!this.getRoot().getAllowLinking()) {
                        boolean bl = true;
                        String string2 = null;
                        String string3 = null;
                        try {
                            string2 = file2.getAbsolutePath().substring(file.getAbsolutePath().length());
                            String string4 = file2.getCanonicalPath();
                            String string5 = file.getCanonicalPath();
                            if (string4.length() >= string5.length() && string2.equals(string3 = string4.substring(string5.length()))) {
                                bl = false;
                            }
                        }
                        catch (IOException iOException) {
                            string3 = "Unknown";
                        }
                        if (bl) {
                            this.logIgnoredSymlink(this.getRoot().getContext().getName(), string2, string3);
                            continue;
                        }
                    }
                    StringBuilder stringBuilder = new StringBuilder((String)object);
                    if (((String)object).charAt(((String)object).length() - 1) != '/') {
                        stringBuilder.append('/');
                    }
                    stringBuilder.append(file2.getName());
                    if (file2.isDirectory()) {
                        stringBuilder.append('/');
                    }
                    resourceSet.add(stringBuilder.toString());
                }
            }
        } else {
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            if (string.startsWith((String)object)) {
                int n = string.indexOf(47, ((String)object).length());
                if (n == -1) {
                    resourceSet.add(string + "/");
                } else {
                    resourceSet.add(string.substring(0, n + 1));
                }
            }
        }
        resourceSet.setLocked(true);
        return resourceSet;
    }

    @Override
    public boolean mkdir(String string) {
        this.checkPath(string);
        if (this.isReadOnly()) {
            return false;
        }
        String string2 = this.getWebAppMount();
        if (string.startsWith(string2)) {
            File file = this.file(string.substring(string2.length()), false);
            if (file == null) {
                return false;
            }
            return file.mkdir();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(String string, InputStream inputStream, boolean bl) {
        this.checkPath(string);
        if (inputStream == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (string.endsWith("/")) {
            return false;
        }
        String string2 = this.getWebAppMount();
        if (!string.startsWith(string2)) {
            return false;
        }
        WebResourceLockSet.ResourceLock resourceLock = this.lockForWrite(string);
        try {
            File file = this.file(string.substring(string2.length()), false);
            if (file == null) {
                boolean bl2 = false;
                return bl2;
            }
            if (file.exists() && !bl) {
                boolean bl3 = false;
                return bl3;
            }
            try {
                if (bl) {
                    Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(inputStream, file.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException iOException) {
                boolean bl4 = false;
                this.unlockForWrite(resourceLock);
                return bl4;
            }
            boolean bl5 = true;
            return bl5;
        }
        finally {
            this.unlockForWrite(resourceLock);
        }
    }

    @Override
    protected void checkType(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(sm.getString("dirResourceSet.notDirectory", new Object[]{this.getBase(), File.separator, this.getInternalPath()}));
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        File file;
        super.initInternal();
        if (this.getWebAppMount().isEmpty() && (file = this.file("META-INF/MANIFEST.MF", true)) != null && file.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                this.setManifest(new Manifest(fileInputStream));
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("dirResourceSet.manifestFail", new Object[]{file.getAbsolutePath()}), (Throwable)iOException);
            }
        }
        if (this.isReadOnly()) {
            return;
        }
        if (JreCompat.getInstance().isCanonCachesDisabled()) {
            return;
        }
        if (!JreCompat.getInstance().disableCanonCaches()) {
            throw new IllegalStateException(sm.getString("dirResourceSet.canonCaches.enabled", new Object[]{this.getFileBase(), this.getRoot().getContext().getName()}));
        }
        log.warn((Object)sm.getString("dirResourceSet.canonCaches.disabled", new Object[]{this.getFileBase(), this.getRoot().getContext().getName()}));
    }

    private String getLockKey(String string) {
        return RequestUtil.normalize((String)string).toLowerCase(Locale.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResourceLockSet.ResourceLock lockForRead(String string) {
        WebResourceLockSet.ResourceLock resourceLock;
        String string2 = this.getLockKey(string);
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            resourceLock = this.resourceLocksByPath.get(string2);
            if (resourceLock == null) {
                resourceLock = new WebResourceLockSet.ResourceLock(string2);
                this.resourceLocksByPath.put(string2, resourceLock);
            }
            resourceLock.count.incrementAndGet();
        }
        resourceLock.reentrantLock.readLock().lock();
        return resourceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockForRead(WebResourceLockSet.ResourceLock resourceLock) {
        resourceLock.reentrantLock.readLock().unlock();
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            if (resourceLock.count.decrementAndGet() == 0) {
                this.resourceLocksByPath.remove(resourceLock.key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResourceLockSet.ResourceLock lockForWrite(String string) {
        WebResourceLockSet.ResourceLock resourceLock;
        String string2 = this.getLockKey(string);
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            resourceLock = this.resourceLocksByPath.get(string2);
            if (resourceLock == null) {
                resourceLock = new WebResourceLockSet.ResourceLock(string2);
                this.resourceLocksByPath.put(string2, resourceLock);
            }
            resourceLock.count.incrementAndGet();
        }
        resourceLock.reentrantLock.writeLock().lock();
        return resourceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockForWrite(WebResourceLockSet.ResourceLock resourceLock) {
        resourceLock.reentrantLock.writeLock().unlock();
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            if (resourceLock.count.decrementAndGet() == 0) {
                this.resourceLocksByPath.remove(resourceLock.key);
            }
        }
    }
}

