/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.llm.textvectorisation.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.llm.textvectorisation.model.SolrTextToVectorModel;
import org.apache.solr.llm.textvectorisation.store.TextToVectorModelException;

public class TextToVectorModelStore {
    private final Map<String, SolrTextToVectorModel> availableModels = Collections.synchronizedMap(new LinkedHashMap());

    public SolrTextToVectorModel getModel(String name) {
        return this.availableModels.get(name);
    }

    public void clear() {
        this.availableModels.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SolrTextToVectorModel> getModels() {
        Map<String, SolrTextToVectorModel> map = this.availableModels;
        synchronized (map) {
            ArrayList<SolrTextToVectorModel> availableModelsValues = new ArrayList<SolrTextToVectorModel>(this.availableModels.values());
            return Collections.unmodifiableList(availableModelsValues);
        }
    }

    public String toString() {
        return "ModelStore [availableModels=" + String.valueOf(this.availableModels.keySet()) + "]";
    }

    public SolrTextToVectorModel delete(String modelName) {
        return this.availableModels.remove(modelName);
    }

    public void addModel(SolrTextToVectorModel modeldata) throws TextToVectorModelException {
        String name = modeldata.getName();
        if (this.availableModels.putIfAbsent(modeldata.getName(), modeldata) != null) {
            throw new TextToVectorModelException("model '" + name + "' already exists. Please use a different name");
        }
    }
}

