/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.vector;

import org.apache.solr.util.vector.DenseVectorParser;

public class ByteDenseVectorParser
extends DenseVectorParser {
    private byte[] byteVector;
    private int curPosition;

    public ByteDenseVectorParser(int dimension, Object inputValue, DenseVectorParser.BuilderPhase builderPhase) {
        this.dimension = dimension;
        this.inputValue = inputValue;
        this.builderPhase = builderPhase;
        this.curPosition = 0;
    }

    @Override
    public byte[] getByteVector() {
        if (this.byteVector == null) {
            this.byteVector = new byte[this.dimension];
            this.parseVector();
        }
        return this.byteVector;
    }

    @Override
    protected void addNumberElement(Number element) {
        this.byteVector[this.curPosition++] = element.byteValue();
    }

    @Override
    protected void addStringElement(String element) {
        this.byteVector[this.curPosition++] = Byte.parseByte(element);
    }

    @Override
    protected String errorMessage() {
        return "The expected format is:'[b1,b2..b3]' where each element b is a byte (-128 to 127)";
    }
}

