/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.math.mahout.map;

import org.carrot2.math.mahout.Sorting;
import org.carrot2.math.mahout.Swapper;
import org.carrot2.math.mahout.function.DoubleFunction;
import org.carrot2.math.mahout.function.IntComparator;
import org.carrot2.math.mahout.function.IntDoubleProcedure;
import org.carrot2.math.mahout.function.IntProcedure;
import org.carrot2.math.mahout.list.DoubleArrayList;
import org.carrot2.math.mahout.list.IntArrayList;
import org.carrot2.math.mahout.set.AbstractSet;

public abstract class AbstractIntDoubleMap
extends AbstractSet {
    public boolean containsKey(final int key) {
        return !this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final double value) {
        return !this.forEachPair(new IntDoubleProcedure(){

            @Override
            public boolean apply(int iterKey, double iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractIntDoubleMap copy() {
        return (AbstractIntDoubleMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractIntDoubleMap)) {
            return false;
        }
        final AbstractIntDoubleMap other = (AbstractIntDoubleMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntDoubleProcedure(){

            @Override
            public boolean apply(int key, double value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new IntDoubleProcedure(){

            @Override
            public boolean apply(int key, double value) {
                return AbstractIntDoubleMap.this.containsKey(key) && AbstractIntDoubleMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntDoubleProcedure procedure) {
        return this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                return procedure.apply(key, AbstractIntDoubleMap.this.get(key));
            }
        });
    }

    public abstract double get(int var1);

    public IntArrayList keys() {
        IntArrayList list = new IntArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList keyList) {
        this.pairsSortedByValue(keyList, new DoubleArrayList(this.size()));
    }

    public void pairsMatching(final IntDoubleProcedure condition, final IntArrayList keyList, final DoubleArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new IntDoubleProcedure(){

            @Override
            public boolean apply(int key, double value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(IntArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final int[] k = keyList.elements();
        final double[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                double t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                int t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(int var1, double var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        IntArrayList theKeys = new IntArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public DoubleArrayList values() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                list.add(AbstractIntDoubleMap.this.get(key));
                return true;
            }
        });
    }

    public void assign(final DoubleFunction function) {
        this.copy().forEachPair(new IntDoubleProcedure(){

            @Override
            public boolean apply(int key, double value) {
                AbstractIntDoubleMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractIntDoubleMap other) {
        this.clear();
        other.forEachPair(new IntDoubleProcedure(){

            @Override
            public boolean apply(int key, double value) {
                AbstractIntDoubleMap.this.put(key, value);
                return true;
            }
        });
    }

    public double adjustOrPutValue(int key, double newValue, double incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

