from typing import Any, TypeVar


class _DefaultPlaceholder:
    """
    You shouldn't use this class directly.

    It's used internally to recognize when a default value has been overwritten, even
    if the overridden default value was truthy.
    """

    def __init__(self, value: Any):
        self.value = value

    def __bool__(self) -> bool:
        return bool(self.value)

    def __eq__(self, o: object) -> bool:
        return isinstance(o, _DefaultPlaceholder) and o.value == self.value


_TDefaultType = TypeVar("_TDefaultType")


def Default(value: _TDefaultType) -> _TDefaultType:
    """
    You shouldn't use this function directly.

    It's used internally to recognize when a default value has been overwritten, even
    if the overridden default value was truthy.
    """
    return _DefaultPlaceholder(value)  # type: ignore
