#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-KkvBXXrTpLqJ8eW3L1O6q4
key:                  postgrest-10.0.0-KkvBXXrTpLqJ8eW3L1O6q4
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  99e8838317bed164d7b619eb045a01f2
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-KkvBXXrTpLqJ8eW3L1O6q4
depends:
    HTTP-4000.4.1-DyrpOXPVORM8lcM6MkEz8l
    Ranged-sets-0.5.0-4x3YukNF8F33NQjVoVVHlF
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH
    auto-update-0.1.6-IorJvrdEDBmcBiUjZpeWz base-4.17.2.1
    base64-bytestring-1.2.1.0-8gOUUHpnCxrFKKvfql8iQu
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-IiC4W3ne2FhKO4v0Ko50kd
    cassava-0.5.4.0-ALJ2S0OoSaCEEsDTv6AWBy
    configurator-pg-0.2.10-DTiJhrTd6E3OEaxQIVnXB containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.3-HSeWVXxcHDG8FkBCehblq1
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-DxWySFFce7qIF64DwbLbVW
    hasql-dynamic-statements-0.3.1.1-1TeZyXLEvpTAAy0LwGZxG9
    hasql-notifications-0.2.0.5-DjhYJgRd22u5CTZkvMWnlA
    hasql-pool-0.5.2.2-792P8clWARA1vG06VP91KE
    hasql-transaction-1.0.1.1-wFgO23a2YyEtEvFGKQxik
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-GvCYNDYAmXh2LOy70F8sjw
    insert-ordered-containers-0.2.5.3-F6v1pueV991LcZX5PolEK2
    interpolatedstring-perl6-1.0.2-5kSl8jnOPewKYyosu0Da4m
    jose-0.10-2VFgbc5pffsCp92xDI2f8C lens-5.3-8ZK9QDANmBT9CZTQ77OGiP
    lens-aeson-1.2.3-AR4dAwmoVQyFLDhvguwPol mtl-2.2.2
    network-3.1.4.0-FVkzt15CfOKCnNYpElqt5j
    network-uri-2.6.4.2-3JlqJJTWpo6F8MNpnCbeng
    optparse-applicative-0.18.1.0-26u6tT1hMVXIAnAEQGbXYx
    parsec-3.1.16.1 protolude-0.3.5-3Ree5oM6YTH6ffLyGUhTbE
    regex-tdfa-1.3.2.4-2Uo4qPcx0CLKy09GMSjSu0
    retry-0.9.3.1-GNIh5v3G3KG9DiA6Bop39V
    scientific-0.3.7.0-43723I2k3fJ8FjtljY7WIm
    swagger2-2.8.10-Ky1akpEUyPN6fpHS4zi4wq text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-Asw2mvs6LgrELNyeUEam3W
    vault-0.3.1.5-Eb03pMwbKzc5G8xcHdrzGR
    vector-0.13.2.0-G0g5gCprguQ6M58H7uQE53
    wai-3.2.4-DJtePRgkPSAKQC3jHqxeSS
    wai-cors-0.2.7-HM0dRK9dehR7evdVXN4qwt
    wai-extra-3.1.17-BgTnJYFpvTW5DPNNXI6bL0
    wai-logger-2.5.0-7bHjIPVpURULu0Q2HNRPwY
    warp-3.3.30-3irRUupnRJMJv621SK3LV5

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

