/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import net.atmp.SpecialText;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.SName;

class USymbolFrame
extends USymbol {
    private final SName sname;

    @Override
    public SName[] getSNames() {
        return new SName[]{this.sname};
    }

    public USymbolFrame(SName sname) {
        this.sname = sname;
    }

    private void drawFrame(UGraphic ug, double width, double height, XDimension2D dimTitle, double shadowing, double roundCorner) {
        int cornersize;
        double textWidth;
        URectangle rectangle = URectangle.build(width, height).rounded(roundCorner).ignoreForCompressionOnX().ignoreForCompressionOnY();
        rectangle.setDeltaShadow(shadowing);
        ug.draw(rectangle);
        if (dimTitle.getWidth() == 0.0) {
            textWidth = width / 3.0;
            cornersize = 7;
        } else {
            textWidth = dimTitle.getWidth() + 10.0;
            cornersize = 10;
        }
        double textHeight = this.getYpos(dimTitle);
        UPath line = UPath.none();
        line.setIgnoreForCompressionOnX();
        line.moveTo(textWidth, 0.0);
        line.lineTo(textWidth, textHeight - (double)cornersize);
        line.lineTo(textWidth - (double)cornersize, textHeight);
        line.lineTo(0.0, textHeight);
        ug.apply(HColors.none().bg()).draw(line);
    }

    private double getYpos(XDimension2D dimTitle) {
        if (dimTitle.getWidth() == 0.0) {
            return 12.0;
        }
        return dimTitle.getHeight() + 3.0;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 25.0, 20.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(this){
            final /* synthetic */ USymbolFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                this.this$0.drawFrame(ug, dim.getWidth(), dim.getHeight(), new XDimension2D(0.0, 0.0), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                USymbol.Margin margin = this.this$0.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return this.this$0.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(this){
            final /* synthetic */ USymbolFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                XDimension2D dim = this.calculateDimension(stringBounder);
                ug = symbolContext.apply(ug);
                XDimension2D dimTitle = title.calculateDimension(stringBounder);
                double widthFull = dim.getWidth();
                this.this$0.drawFrame(ug, widthFull, dim.getHeight(), dimTitle, symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                double widthTitle = title.calculateDimension(stringBounder).getWidth();
                if (widthFull - widthTitle < 25.0) {
                    title.drawU(ug.apply(new UTranslate(3.0, 1.0)));
                } else {
                    ug.apply(new UTranslate(3.0, 1.0)).draw(new SpecialText(title));
                }
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(4.0 + posStereo, 2.0 + this.this$0.getYpos(dimTitle))));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

