/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.asciiart.AsciiShape;
import net.sourceforge.plantuml.asciiart.ComponentTextActiveLine;
import net.sourceforge.plantuml.asciiart.ComponentTextActor;
import net.sourceforge.plantuml.asciiart.ComponentTextArrow;
import net.sourceforge.plantuml.asciiart.ComponentTextDelay;
import net.sourceforge.plantuml.asciiart.ComponentTextDestroy;
import net.sourceforge.plantuml.asciiart.ComponentTextDivider;
import net.sourceforge.plantuml.asciiart.ComponentTextGroupingElse;
import net.sourceforge.plantuml.asciiart.ComponentTextGroupingHeader;
import net.sourceforge.plantuml.asciiart.ComponentTextLine;
import net.sourceforge.plantuml.asciiart.ComponentTextNewpage;
import net.sourceforge.plantuml.asciiart.ComponentTextNote;
import net.sourceforge.plantuml.asciiart.ComponentTextParticipant;
import net.sourceforge.plantuml.asciiart.ComponentTextReference;
import net.sourceforge.plantuml.asciiart.ComponentTextSelfArrow;
import net.sourceforge.plantuml.asciiart.ComponentTextShape;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;

public class TextSkin
extends Rose {
    private final FileFormat fileFormat;

    public TextSkin(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    @Override
    public ArrowComponent createComponentArrow(Style[] styles, ArrowConfiguration config, ISkinParam param, Display stringsToDisplay) {
        if (config.getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL || config.getArrowDirection() == ArrowDirection.RIGHT_TO_LEFT_REVERSE || config.getArrowDirection() == ArrowDirection.BOTH_DIRECTION) {
            return new ComponentTextArrow(ComponentType.ARROW, config, stringsToDisplay, this.fileFormat, param.maxAsciiMessageLength());
        }
        if (config.isSelfArrow()) {
            return new ComponentTextSelfArrow(ComponentType.ARROW, config, stringsToDisplay, this.fileFormat);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Component createComponentNote(Style[] styles, ComponentType type, ISkinParam param, Display stringsToDisplay, Colors colors, NotePosition notePosition) {
        if (type == ComponentType.NOTE || type == ComponentType.NOTE_BOX || type == ComponentType.NOTE_HEXAGONAL) {
            return new ComponentTextNote(type, stringsToDisplay, this.fileFormat);
        }
        throw new UnsupportedOperationException(type.toString());
    }

    @Override
    public Component createComponentNote(Style[] styles, ComponentType type, ISkinParam param, Display stringsToDisplay, Colors colors) {
        return this.createComponentNote(styles, type, param, stringsToDisplay, colors, null);
    }

    @Override
    public Component createComponentParticipant(Participant p, ComponentType type, ArrowConfiguration config, ISkinParam param, Display stringsToDisplay) {
        return this.createComponent(p.getUsedStyles(), type, config, param, stringsToDisplay);
    }

    @Override
    public Component createComponent(Style[] style, ComponentType type, ArrowConfiguration config, ISkinParam param, Display stringsToDisplay) {
        if (type == ComponentType.ACTOR_HEAD || type == ComponentType.ACTOR_TAIL) {
            return new ComponentTextActor(type, stringsToDisplay, this.fileFormat, this.fileFormat == FileFormat.UTXT ? AsciiShape.STICKMAN_UNICODE : AsciiShape.STICKMAN);
        }
        if (type == ComponentType.BOUNDARY_HEAD || type == ComponentType.BOUNDARY_TAIL) {
            return new ComponentTextShape(type, stringsToDisplay, AsciiShape.BOUNDARY);
        }
        if (type == ComponentType.DATABASE_HEAD || type == ComponentType.DATABASE_TAIL) {
            return new ComponentTextShape(type, stringsToDisplay, AsciiShape.DATABASE);
        }
        if (type.name().endsWith("_HEAD") || type.name().endsWith("_TAIL")) {
            return new ComponentTextParticipant(type, stringsToDisplay, this.fileFormat);
        }
        if (type.isArrow() && (config.getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL || config.getArrowDirection() == ArrowDirection.RIGHT_TO_LEFT_REVERSE || config.getArrowDirection() == ArrowDirection.BOTH_DIRECTION)) {
            return new ComponentTextArrow(type, config, stringsToDisplay, this.fileFormat, param.maxAsciiMessageLength());
        }
        if (type.isArrow() && config.isSelfArrow()) {
            return new ComponentTextSelfArrow(type, config, stringsToDisplay, this.fileFormat);
        }
        if (type == ComponentType.PARTICIPANT_LINE) {
            return new ComponentTextLine(type, this.fileFormat);
        }
        if (type == ComponentType.CONTINUE_LINE) {
            return new ComponentTextLine(type, this.fileFormat);
        }
        if (type == ComponentType.DELAY_LINE) {
            return new ComponentTextLine(type, this.fileFormat);
        }
        if (type == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (type == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (type == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (type == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (type == ComponentType.DIVIDER) {
            return new ComponentTextDivider(type, stringsToDisplay, this.fileFormat);
        }
        if (type == ComponentType.GROUPING_HEADER_LEGACY || type == ComponentType.GROUPING_HEADER_TEOZ) {
            return new ComponentTextGroupingHeader(type, stringsToDisplay, this.fileFormat);
        }
        if (type == ComponentType.GROUPING_SPACE) {
            return new ComponentRoseGroupingSpace(1.0);
        }
        if (type == ComponentType.GROUPING_ELSE_LEGACY || type == ComponentType.GROUPING_ELSE_TEOZ) {
            return new ComponentTextGroupingElse(type, stringsToDisplay, this.fileFormat);
        }
        if (type == ComponentType.DELAY_TEXT) {
            return new ComponentTextDelay(type, stringsToDisplay, this.fileFormat);
        }
        if (type == ComponentType.DESTROY) {
            return new ComponentTextDestroy();
        }
        if (type == ComponentType.REFERENCE) {
            return new ComponentTextReference(stringsToDisplay, this.fileFormat);
        }
        throw new UnsupportedOperationException(type.toString());
    }

    @Override
    public Component createComponentNewPage(Style[] styles, ISkinParam param) {
        return new ComponentTextNewpage(this.fileFormat);
    }
}

