/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.Challenge;
import com.plantuml.ubrex.ChallengeResult;
import com.plantuml.ubrex.LookAround;
import com.plantuml.ubrex.TextNavigator;

public class ChallengeLookAhead
implements Challenge {
    private final Challenge origin;
    private final LookAround ahead;

    public ChallengeLookAhead(Challenge origin, LookAround ahead) {
        this.origin = origin;
        this.ahead = ahead;
    }

    public String toString() {
        return this.ahead.toString() + " " + this.origin;
    }

    @Override
    public ChallengeResult runChallenge(TextNavigator string, int position) {
        int tmp = this.origin.runChallenge(string, position).getFullCaptureLength();
        switch (this.ahead) {
            case LOOK_AHEAD_POSITIVE: {
                if (tmp < 0) {
                    return new ChallengeResult(Integer.MIN_VALUE);
                }
                return new ChallengeResult(0);
            }
            case LOOK_AHEAD_NEGATIVE: {
                if (tmp < 0) {
                    return new ChallengeResult(0);
                }
                return new ChallengeResult(Integer.MIN_VALUE);
            }
        }
        throw new IllegalStateException();
    }
}

