/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4jextensions.persistence;

import com.microsoft.aad.msal4jextensions.persistence.CacheFileAccessException;
import com.microsoft.aad.msal4jextensions.persistence.ICacheAccessor;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Crypt32Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFileAccessor
implements ICacheAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(CacheFileAccessor.class);
    private String cacheFilePath;
    private File cacheFile;

    public CacheFileAccessor(String cacheFilePath) {
        this.cacheFilePath = cacheFilePath;
        this.cacheFile = new File(cacheFilePath);
    }

    @Override
    public byte[] read() {
        byte[] data = null;
        if (this.cacheFile.exists()) {
            try {
                data = Files.readAllBytes(this.cacheFile.toPath());
            }
            catch (IOException e) {
                throw new CacheFileAccessException("Failed to read Cache File", e);
            }
            if (data != null && data.length > 0 && Platform.isWindows()) {
                data = Crypt32Util.cryptUnprotectData((byte[])data);
            }
        }
        return data;
    }

    @Override
    public void write(byte[] data) {
        block15: {
            if (Platform.isWindows()) {
                data = Crypt32Util.cryptProtectData((byte[])data);
                try (FileOutputStream stream = new FileOutputStream(this.cacheFile);){
                    stream.write(data);
                    break block15;
                }
                catch (IOException e) {
                    throw new CacheFileAccessException("Failed to write to Cache File", e);
                }
            }
            this.writeAtomic(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAtomic(byte[] data) {
        File tempFile = null;
        try {
            try {
                tempFile = File.createTempFile("JavaMsalExtTemp", ".tmp", this.cacheFile.getParentFile());
                try (FileOutputStream stream = new FileOutputStream(tempFile);){
                    stream.write(data);
                }
                Files.move(tempFile.toPath(), this.cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            finally {
                if (tempFile != null) {
                    Files.deleteIfExists(tempFile.toPath());
                }
            }
        }
        catch (IOException e) {
            throw new CacheFileAccessException("Failed to write to Cache File", e);
        }
    }

    @Override
    public void delete() {
        try {
            Files.deleteIfExists(new File(this.cacheFilePath).toPath());
        }
        catch (IOException e) {
            throw new CacheFileAccessException("Failed to delete Cache File", e);
        }
    }

    public void updateCacheFileLastModifiedTime() {
        FileTime fileTime = FileTime.fromMillis(System.currentTimeMillis());
        try {
            Files.setLastModifiedTime(Paths.get(this.cacheFilePath, new String[0]), fileTime);
        }
        catch (IOException e) {
            throw new CacheFileAccessException("Failed to set lastModified time on Cache File", e);
        }
    }
}

