/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.client;

import com.sun.mail.util.MailConnectException;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeMessage;
import java.util.Map;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.notifications.core.client.EmailMessageValidator;
import org.opensearch.notifications.core.client.EmailMimeProvider;
import org.opensearch.notifications.core.setting.PluginSettings;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.core.utils.SecurityAccess;
import org.opensearch.notifications.spi.model.DestinationMessageResponse;
import org.opensearch.notifications.spi.model.MessageContent;
import org.opensearch.notifications.spi.model.SecureDestinationSettings;
import org.opensearch.notifications.spi.model.destination.SmtpDestination;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/notifications/core/client/DestinationSmtpClient;", "", "()V", "execute", "Lorg/opensearch/notifications/spi/model/DestinationMessageResponse;", "smtpDestination", "Lorg/opensearch/notifications/spi/model/destination/SmtpDestination;", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "referenceId", "", "getMessagingExceptionText", "exception", "Ljakarta/mail/MessagingException;", "getSecureDestinationSetting", "Lorg/opensearch/notifications/spi/model/SecureDestinationSettings;", "SmtpDestination", "sendMessage", "", "msg", "Ljakarta/mail/Message;", "sendMimeMessage", "mimeMessage", "Ljakarta/mail/internet/MimeMessage;", "Companion", "opensearch-notifications-core"})
public final class DestinationSmtpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(DestinationSmtpClient.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final DestinationMessageResponse execute(@NotNull SmtpDestination smtpDestination, @NotNull MessageContent message, @NotNull String referenceId) throws Exception {
        SecureDestinationSettings secureDestinationSetting;
        Session session;
        Properties prop;
        block8: {
            Intrinsics.checkNotNullParameter((Object)smtpDestination, (String)"smtpDestination");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
            if (EmailMessageValidator.INSTANCE.isMessageSizeOverLimit(message)) {
                return new DestinationMessageResponse(RestStatus.REQUEST_ENTITY_TOO_LARGE.getStatus(), "Email size larger than " + PluginSettings.INSTANCE.getEmailSizeLimit());
            }
            prop = new Properties();
            ((Map)prop).put("mail.transport.protocol", "smtp");
            ((Map)prop).put("mail.smtp.host", smtpDestination.getHost());
            ((Map)prop).put("mail.smtp.port", smtpDestination.getPort());
            session = Session.getInstance((Properties)prop);
            String string = smtpDestination.getMethod();
            switch (string.hashCode()) {
                case -2128956514: {
                    if (string.equals("start_tls")) break;
                    throw new IllegalArgumentException("Invalid method supplied");
                }
                case 3387192: {
                    if (!string.equals("none")) {
                        throw new IllegalArgumentException("Invalid method supplied");
                    }
                    break block8;
                }
                case 114188: {
                    if (!string.equals("ssl")) throw new IllegalArgumentException("Invalid method supplied");
                    ((Map)prop).put("mail.smtp.ssl.enable", true);
                    break block8;
                }
            }
            ((Map)prop).put("mail.smtp.starttls.enable", true);
            break block8;
            throw new IllegalArgumentException("Invalid method supplied");
        }
        if (!Intrinsics.areEqual((Object)smtpDestination.getMethod(), (Object)"none") && (secureDestinationSetting = this.getSecureDestinationSetting(smtpDestination)) != null) {
            ((Map)prop).put("mail.smtp.auth", true);
            session = Session.getInstance((Properties)prop, (Authenticator)new Authenticator(secureDestinationSetting){
                final /* synthetic */ SecureDestinationSettings $secureDestinationSetting;
                {
                    this.$secureDestinationSetting = $secureDestinationSetting;
                }

                @NotNull
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(this.$secureDestinationSetting.getEmailUsername().toString(), this.$secureDestinationSetting.getEmailPassword().toString());
                }
            });
        }
        Session session2 = session;
        Intrinsics.checkNotNull((Object)session2);
        MimeMessage mimeMessage = EmailMimeProvider.INSTANCE.prepareMimeMessage(session2, smtpDestination.getFromAddress(), smtpDestination.getRecipient(), message);
        return this.sendMimeMessage(mimeMessage, referenceId);
    }

    @Nullable
    public final SecureDestinationSettings getSecureDestinationSetting(@NotNull SmtpDestination SmtpDestination2) {
        Intrinsics.checkNotNullParameter((Object)SmtpDestination2, (String)"SmtpDestination");
        SecureDestinationSettings secureDestinationSettings = PluginSettings.INSTANCE.getDestinationSettings().get(SmtpDestination2.getAccountName());
        SecureString emailUsername = secureDestinationSettings != null ? secureDestinationSettings.getEmailUsername() : null;
        SecureDestinationSettings secureDestinationSettings2 = PluginSettings.INSTANCE.getDestinationSettings().get(SmtpDestination2.getAccountName());
        SecureString emailPassword = secureDestinationSettings2 != null ? secureDestinationSettings2.getEmailPassword() : null;
        return emailUsername == null || emailPassword == null ? null : new SecureDestinationSettings(emailUsername, emailPassword);
    }

    private final DestinationMessageResponse sendMimeMessage(MimeMessage mimeMessage, String referenceId) {
        DestinationMessageResponse destinationMessageResponse;
        try {
            DestinationSmtpClient.Companion.getLog().debug("Sending Email-SMTP for " + referenceId);
            SecurityAccess.INSTANCE.doPrivileged(() -> DestinationSmtpClient.sendMimeMessage$lambda$0(this, mimeMessage));
            DestinationSmtpClient.Companion.getLog().info("Email-SMTP sent for " + referenceId);
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.OK.getStatus(), "Success");
        }
        catch (SendFailedException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.BAD_GATEWAY.getStatus(), this.getMessagingExceptionText((MessagingException)((Object)exception)));
        }
        catch (MailConnectException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.SERVICE_UNAVAILABLE.getStatus(), this.getMessagingExceptionText((MessagingException)((Object)exception)));
        }
        catch (MessagingException exception) {
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getMessagingExceptionText(exception));
        }
        return destinationMessageResponse;
    }

    public final void sendMessage(@Nullable Message msg) throws Exception {
        Transport.send((Message)msg);
    }

    private final String getMessagingExceptionText(MessagingException exception) {
        DestinationSmtpClient.Companion.getLog().info("EmailException " + exception);
        return "sendEmail Error, status:" + exception.getMessage();
    }

    private static final Unit sendMimeMessage$lambda$0(DestinationSmtpClient this$0, MimeMessage $mimeMessage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mimeMessage, (String)"$mimeMessage");
        this$0.sendMessage((Message)$mimeMessage);
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/opensearch/notifications/core/client/DestinationSmtpClient$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "opensearch-notifications-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

