/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.shard_stores;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardStoreException
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardStoreException> {
    @Nonnull
    private final String reason;
    @Nonnull
    private final String type;
    public static final JsonpDeserializer<ShardStoreException> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStoreException::setupShardStoreExceptionDeserializer);

    private ShardStoreException(Builder builder) {
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static ShardStoreException of(Function<Builder, ObjectBuilder<ShardStoreException>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String reason() {
        return this.reason;
    }

    @Nonnull
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("type");
        generator.write(this.type);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardStoreExceptionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.reason.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardStoreException other = (ShardStoreException)o;
        return this.reason.equals(other.reason) && this.type.equals(other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardStoreException> {
        private String reason;
        private String type;

        public Builder() {
        }

        private Builder(ShardStoreException o) {
            this.reason = o.reason;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.reason = o.reason;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        @Nonnull
        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardStoreException build() {
            this._checkSingleUse();
            return new ShardStoreException(this);
        }
    }
}

