/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss.binary;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.store.IndexInput;
import org.opensearch.knn.memoryoptsearch.faiss.FaissSection;
import org.opensearch.knn.memoryoptsearch.faiss.binary.FaissBinaryIndex;

public class FaissIndexBinaryFlat
extends FaissBinaryIndex {
    public static final String IBXF = "IBxF";
    private FaissSection binaryFlatVectorSection;

    public FaissIndexBinaryFlat() {
        super(IBXF);
    }

    @Override
    protected void doLoad(IndexInput input) throws IOException {
        this.readBinaryCommonHeader(input);
        this.binaryFlatVectorSection = new FaissSection(input, 1);
    }

    @Override
    public VectorEncoding getVectorEncoding() {
        return VectorEncoding.BYTE;
    }

    @Override
    public FloatVectorValues getFloatValues(IndexInput indexInput) throws IOException {
        throw new UnsupportedOperationException(FaissIndexBinaryFlat.class.getSimpleName() + " does not support FloatValues.");
    }

    @Override
    public ByteVectorValues getByteValues(IndexInput indexInput) throws IOException {
        class ByteVectorValuesImpl
        extends ByteVectorValues {
            final IndexInput indexInput;
            final byte[] buffer;

            public byte[] vectorValue(int internalVectorId) throws IOException {
                long offset = FaissIndexBinaryFlat.this.binaryFlatVectorSection.getBaseOffset() + (long)internalVectorId * (long)FaissIndexBinaryFlat.this.codeSize;
                this.indexInput.seek(offset);
                this.indexInput.readBytes(this.buffer, 0, FaissIndexBinaryFlat.this.codeSize);
                return this.buffer;
            }

            public int dimension() {
                return FaissIndexBinaryFlat.this.dimension;
            }

            public int size() {
                return FaissIndexBinaryFlat.this.totalNumberOfVectors;
            }

            public ByteVectorValues copy() {
                return new ByteVectorValuesImpl(this.indexInput.clone());
            }

            @Generated
            public ByteVectorValuesImpl(IndexInput indexInput) {
                this.buffer = new byte[FaissIndexBinaryFlat.this.codeSize];
                this.indexInput = indexInput;
            }
        }
        return new ByteVectorValuesImpl(indexInput);
    }
}

