/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.pipeline.jersey;

import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseContext;
import com.microsoft.windowsazure.core.pipeline.jersey.RetryPolicy;
import java.util.Arrays;
import java.util.Random;

public class ExponentialRetryPolicy
extends RetryPolicy {
    private final int deltaBackoffIntervalInMs;
    private final int maximumAttempts;
    private final Random randRef = new Random();
    private final int resolvedMaxBackoff = 90000;
    private final int resolvedMinBackoff = 300;
    private final int[] retryableStatusCodes;

    public ExponentialRetryPolicy(int[] retryableStatusCodes) {
        this(30000, 3, retryableStatusCodes);
    }

    public ExponentialRetryPolicy(int deltaBackoff, int maximumAttempts, int[] retryableStatusCodes) {
        this.deltaBackoffIntervalInMs = deltaBackoff;
        this.maximumAttempts = maximumAttempts;
        this.retryableStatusCodes = Arrays.copyOf(retryableStatusCodes, retryableStatusCodes.length);
        Arrays.sort(this.retryableStatusCodes);
    }

    @Override
    public boolean shouldRetry(int retryCount, ServiceResponseContext response, Exception error) {
        if (response == null) {
            return false;
        }
        if (retryCount >= this.maximumAttempts) {
            return false;
        }
        return Arrays.binarySearch(this.retryableStatusCodes, response.getStatus()) >= 0;
    }

    @Override
    public int calculateBackoff(int currentRetryCount, ServiceResponseContext response, Exception error) {
        int incrementDelta = (int)(Math.pow(2.0, currentRetryCount) - 1.0);
        int boundedRandDelta = (int)((double)this.deltaBackoffIntervalInMs * 0.8) + this.randRef.nextInt((int)((double)this.deltaBackoffIntervalInMs * 1.2) - (int)((double)this.deltaBackoffIntervalInMs * 0.8));
        return Math.min(this.resolvedMinBackoff + (incrementDelta *= boundedRandDelta), this.resolvedMaxBackoff);
    }
}

