/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ml;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opensearch.timeseries.ExpiringState;
import org.opensearch.timeseries.ml.Sample;
import org.opensearch.timeseries.model.Entity;

public class ModelState<T>
implements ExpiringState {
    public static String MODEL_TYPE_KEY = "model_type";
    public static String LAST_USED_TIME_KEY = "last_used_time";
    public static String LAST_CHECKPOINT_TIME_KEY = "last_checkpoint_time";
    public static String PRIORITY_KEY = "priority";
    protected T model;
    protected String modelId;
    protected String configId;
    protected String modelType;
    protected Instant lastUsedTime;
    protected Instant lastCheckpointTime;
    protected Instant lastSeenDataEndTime;
    protected Clock clock;
    protected float priority;
    protected Deque<Sample> samples;
    protected Optional<Entity> entity;

    public ModelState(T model, String modelId, String configId, String modelType, Clock clock, float priority, Optional<Entity> entity, Deque<Sample> samples) {
        this.model = model;
        this.modelId = modelId;
        this.configId = configId;
        this.modelType = modelType;
        this.lastUsedTime = clock.instant();
        this.lastCheckpointTime = Instant.MIN;
        this.clock = clock;
        this.priority = priority;
        this.entity = entity;
        this.samples = samples;
        this.lastSeenDataEndTime = Instant.MIN;
    }

    public ModelState(T model, String modelId, String configId, String modelType, Clock clock) {
        this(model, modelId, configId, modelType, clock, 0.0f, Optional.empty(), new ArrayDeque<Sample>());
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Instant getLastUsedTime() {
        return this.lastUsedTime;
    }

    public void setLastUsedTime(Instant lastUsedTime) {
        this.lastUsedTime = lastUsedTime;
    }

    public Instant getLastCheckpointTime() {
        return this.lastCheckpointTime;
    }

    public void setLastCheckpointTime(Instant lastCheckpointTime) {
        this.lastCheckpointTime = lastCheckpointTime;
    }

    public float getPriority() {
        return this.priority;
    }

    public void setPriority(float priority) {
        this.priority = priority;
    }

    @Override
    public boolean expired(Duration stateTtl) {
        return this.expired(this.lastUsedTime, stateTtl, this.clock.instant());
    }

    public String getConfigId() {
        return this.configId;
    }

    public Optional<Entity> getEntity() {
        return this.entity;
    }

    public Deque<Sample> getSamples() {
        return this.samples;
    }

    public void addSample(Sample sample) {
        if (this.samples == null) {
            this.samples = new ArrayDeque<Sample>();
        }
        if (sample != null && sample.getValueList() != null && sample.getValueList().length != 0) {
            this.samples.add(sample);
        }
    }

    public void setModel(T model) {
        this.model = model;
    }

    public Optional<T> getModel() {
        return Optional.ofNullable(this.model);
    }

    public void clearSamples() {
        if (this.samples != null) {
            this.samples.clear();
        }
    }

    public void clear() {
        this.clearSamples();
        this.model = null;
    }

    public Map<String, Object> getModelStateAsMap() {
        return new HashMap<String, Object>(){
            {
                this.put("model_id", ModelState.this.modelId);
                this.put("config_id", ModelState.this.configId);
                this.put(MODEL_TYPE_KEY, ModelState.this.modelType);
                this.put(LAST_USED_TIME_KEY, ModelState.this.lastUsedTime.toEpochMilli());
                if (ModelState.this.lastCheckpointTime != Instant.MIN) {
                    this.put(LAST_CHECKPOINT_TIME_KEY, ModelState.this.lastCheckpointTime.toEpochMilli());
                }
                if (ModelState.this.entity.isPresent()) {
                    this.put("entity", ModelState.this.entity.get().toStat());
                }
            }
        };
    }

    public Instant getLastSeenDataEndTime() {
        return this.lastSeenDataEndTime;
    }

    public void setLastSeenDataEndTime(Instant lastSeenExecutionEndTime) {
        this.lastSeenDataEndTime = lastSeenExecutionEndTime;
    }
}

