/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.SamplerChannelModel;
import org.jsampler.event.SamplerChannelEvent;
import org.jsampler.event.SamplerChannelListEvent;
import org.jsampler.event.SamplerChannelListListener;
import org.jsampler.event.SamplerChannelListener;
import org.jsampler.view.JSChannel;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.fantasia.A4n;
import org.jsampler.view.fantasia.ChannelOptionsPane;
import org.jsampler.view.fantasia.ChannelOptionsView;
import org.jsampler.view.fantasia.ChannelView;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.FantasiaUtils;
import org.jsampler.view.fantasia.MainFrame;
import org.jsampler.view.fantasia.MenuManager;
import org.jsampler.view.fantasia.NormalChannelView;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.SmallChannelView;
import org.jsampler.view.fantasia.ToolbarButton;
import org.jsampler.view.fantasia.basic.PixmapToggleButton;
import org.jsampler.view.std.JSChannelOutputRoutingDlg;
import org.jsampler.view.std.JSFxSendsDlg;
import org.jsampler.view.std.JSFxSendsPane;
import org.jsampler.view.std.JSInstrumentChooser;
import org.jsampler.view.std.JSVolumeEditorPopup;
import org.linuxsampler.lscp.SamplerChannel;

public class Channel
extends JSChannel {
    private final JXCollapsiblePane mainPane;
    private final ChannelOptionsPane optionsPane = new ChannelOptionsPane();
    private final ViewTracker viewTracker;
    private JSFxSendsDlg fxSendsDlg = null;
    private final ContextMenu contextMenu;
    private boolean selected = false;
    private AnimatedPorpetyListener animatedPorpetyListener = new AnimatedPorpetyListener();
    private static int mouseOverChannelId = -1;
    private static boolean mousePressed = false;
    private static ActionListener guiListener = null;
    private static Channel oldMouseOverChannel = null;
    private static Channel newMouseOverChannel = null;
    private final EventHandler eventHandler = new EventHandler();

    private static void mouseMoved() {
        JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
        for (int i = 0; i < jSChannelsPane.getChannelCount(); ++i) {
            Channel.mouseMoved((Channel)jSChannelsPane.getChannel(i));
        }
        if (oldMouseOverChannel == newMouseOverChannel) {
            return;
        }
        if (oldMouseOverChannel != null) {
            oldMouseOverChannel.mouseExited();
        }
        if (newMouseOverChannel != null) {
            mouseOverChannelId = newMouseOverChannel.getChannelId();
            newMouseOverChannel.mouseEntered();
        }
        newMouseOverChannel = null;
        oldMouseOverChannel = null;
    }

    private static void mouseMoved(Channel channel) {
        int n = channel.getChannelId();
        if (channel.mainPane.getMousePosition(true) != null) {
            newMouseOverChannel = channel;
        } else if (n == mouseOverChannelId) {
            oldMouseOverChannel = channel;
        }
    }

    public Channel(SamplerChannelModel samplerChannelModel) {
        this(samplerChannelModel, null);
    }

    public Channel(SamplerChannelModel samplerChannelModel, ActionListener actionListener) {
        this(samplerChannelModel, actionListener, FantasiaPrefs.preferences().getIntProperty("defaultChannelView") == 0 ? ChannelView.Type.SMALL : ChannelView.Type.NORMAL);
    }

    public Channel(SamplerChannelModel samplerChannelModel, final ActionListener actionListener, ChannelView.Type type) {
        super(samplerChannelModel);
        this.setLayout(new BoxLayout(this, 1));
        this.optionsPane.setAlignmentX(0.5f);
        this.mainPane = new JXCollapsiblePane();
        this.viewTracker = new ViewTracker();
        this.contextMenu = new ContextMenu();
        this.mainPane.getContentPane().setLayout(new BoxLayout(this.mainPane.getContentPane(), 1));
        switch (type) {
            case SMALL: {
                this.viewTracker.setView(new SmallChannelView(this));
                break;
            }
            case NORMAL: {
                this.viewTracker.setView(new NormalChannelView(this));
                break;
            }
            default: {
                this.viewTracker.setView(new NormalChannelView(this));
            }
        }
        this.setOpaque(false);
        this.getModel().addSamplerChannelListener(this.getHandler());
        this.updateChannelInfo();
        this.add(this.mainPane);
        if (actionListener != null) {
            this.mainPane.addPropertyChangeListener("animationState", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() == "expanded") {
                        Channel.this.mainPane.removePropertyChangeListener("animationState", this);
                        actionListener.actionPerformed(null);
                        Channel.this.ensureChannelIsVisible();
                    } else if (propertyChangeEvent.getNewValue() == "expanding/collapsing") {
                        Channel.this.ensureChannelIsVisible();
                    }
                }
            });
        }
        this.mainPane.setAnimated(false);
        this.mainPane.setCollapsed(true);
        this.mainPane.setAnimated(FantasiaPrefs.preferences().getBoolProperty("animated"));
        this.mainPane.setCollapsed(false);
        FantasiaPrefs.preferences().addPropertyChangeListener("animated", this.animatedPorpetyListener);
        if (actionListener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    actionListener.actionPerformed(null);
                }
            });
        }
        CC.getSamplerModel().addSamplerChannelListListener(this.getHandler());
        Channel.installGuiListener();
    }

    private static void installGuiListener() {
        if (guiListener != null) {
            return;
        }
        guiListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Channel.mouseMoved();
            }
        };
        ((MainFrame)CC.getMainFrame()).getGuiTimer().addActionListener(guiListener);
    }

    private void mouseEntered() {
        this.viewTracker.mouseEntered();
    }

    private void mouseExited() {
        this.viewTracker.mouseExited();
    }

    private void ensureChannelIsVisible() {
        JScrollPane jScrollPane = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JScrollPane)) continue;
            jScrollPane = (JScrollPane)container;
            break;
        }
        if (jScrollPane == null) {
            return;
        }
        int n = jScrollPane.getViewport().getView().getHeight();
        jScrollPane.getViewport().scrollRectToVisible(new Rectangle(0, n - 2, 1, 1));
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean bl) {
        if (this.selected == bl) {
            return;
        }
        this.selected = bl;
        this.repaint();
    }

    public void expandChannel() {
        this.expandChannel(this.optionsPane.isAnimated());
    }

    public void expandChannel(boolean bl) {
        boolean bl2 = this.optionsPane.isAnimated();
        this.optionsPane.setAnimated(bl);
        this.viewTracker.getCurrentView().expandChannel();
        this.optionsPane.setAnimated(bl2);
    }

    private void updateChannelInfo() {
        this.viewTracker.getCurrentView().updateChannelInfo();
    }

    public void loadInstrument() {
        JSInstrumentChooser jSInstrumentChooser = FantasiaUtils.createInstrumentChooser(CC.getMainFrame());
        jSInstrumentChooser.setVisible(true);
        if (!jSInstrumentChooser.isCancelled()) {
            SamplerChannelModel samplerChannelModel = this.getModel();
            samplerChannelModel.loadBackendInstrument(jSInstrumentChooser.getInstrumentFile(), jSInstrumentChooser.getInstrumentIndex());
        }
    }

    public void fallbackToOriginalView() {
        this.viewTracker.fallbackToOriginalView();
    }

    public boolean isUsingOriginalView() {
        return this.viewTracker.isUsingOriginalView();
    }

    protected void onDestroy() {
        CC.getSamplerModel().removeSamplerChannelListListener(this.getHandler());
        FantasiaPrefs.preferences().removePropertyChangeListener("animated", this.animatedPorpetyListener);
        if (this.fxSendsDlg != null) {
            this.fxSendsDlg.dispose();
        }
        this.viewTracker.onDestroy();
    }

    public void remove() {
        if (!this.mainPane.isAnimated()) {
            CC.getSamplerModel().removeBackendChannel(this.getChannelId());
            return;
        }
        String string = "animationState";
        this.mainPane.addPropertyChangeListener(string, this.getHandler());
        this.mainPane.setCollapsed(true);
    }

    public void showOptionsPane(boolean bl) {
        this.optionsPane.showOptionsPane(bl);
    }

    public void showFxSendsDialog() {
        if (this.fxSendsDlg != null && this.fxSendsDlg.isVisible()) {
            this.fxSendsDlg.toFront();
            return;
        }
        this.fxSendsDlg = new JSFxSendsDlg(new FxSendsPane(this.getModel()));
        this.fxSendsDlg.setVisible(true);
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    public ViewTracker getViewTracker() {
        return this.viewTracker;
    }

    public ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    public static class OptionsButton
    extends PixmapToggleButton
    implements ActionListener,
    PropertyChangeListener {
        private final Channel channel;

        OptionsButton(Channel channel) {
            super(Res.gfxOptionsOff, Res.gfxOptionsOn);
            this.channel = channel;
            this.setRolloverIcon(Res.gfxOptionsOffRO);
            this.setRolloverSelectedIcon(Res.gfxOptionsOnRO);
            this.addActionListener(this);
            this.setToolTipText(FantasiaI18n.i18n.getButtonLabel("Channel.ttShowOptions"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            ChannelView channelView = this.channel.viewTracker.getCurrentView();
            if (this.isSelected() && channelView.getChannelOptionsView() == null) {
                channelView.installChannelOptionsView();
                object = channelView.getChannelOptionsView().getComponent();
                this.channel.optionsPane.setContentPane((Container)object);
            }
            this.channel.showOptionsPane(this.isSelected());
            object = this.isSelected() ? FantasiaI18n.i18n.getButtonLabel("Channel.ttHideOptions") : FantasiaI18n.i18n.getButtonLabel("Channel.ttShowOptions");
            this.setToolTipText((String)object);
            object = "animationState";
            this.channel.optionsPane.addPropertyChangeListener((String)object, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getNewValue() == "collapsed") {
                ChannelView channelView = this.channel.viewTracker.getCurrentView();
                channelView.uninstallChannelOptionsView();
                this.channel.optionsPane.setContentPane(new JPanel());
            }
        }

        public void onDestroy() {
            String string = "animationState";
            this.channel.optionsPane.removePropertyChangeListener(string, this);
        }

        @Override
        public boolean contains(int n, int n2) {
            return super.contains(n, n2) & n2 < 13;
        }
    }

    public static class PowerButton
    extends PixmapToggleButton
    implements ActionListener {
        private final Channel channel;

        PowerButton(Channel channel) {
            this(channel, Res.gfxPowerOff, Res.gfxPowerOn);
        }

        PowerButton(Channel channel, ImageIcon imageIcon, ImageIcon imageIcon2) {
            super(imageIcon, imageIcon2);
            this.channel = channel;
            this.setSelected(true);
            this.addActionListener(this);
            this.setToolTipText(FantasiaI18n.i18n.getButtonLabel("Channel.ttRemoveChannel"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            boolean bl = FantasiaPrefs.preferences().getBoolProperty("confirmChannelRemoval");
            if (bl && !HF.showYesNoDialog(this.channel, string = FantasiaI18n.i18n.getMessage("Channel.remove?", this.channel.getChannelId()))) {
                this.setSelected(true);
                return;
            }
            this.channel.remove();
        }

        @Override
        public boolean contains(int n, int n2) {
            return (n - 11) * (n - 11) + (n2 - 11) * (n2 - 11) < 71;
        }
    }

    public static class VolumePane
    extends JPanel {
        private final Channel channel;
        private final JButton btnVolume = FantasiaUtils.createScreenButton("");
        private JSVolumeEditorPopup popupVolume;
        private static NumberFormat numberFormat = NumberFormat.getInstance();

        public VolumePane(final Channel channel) {
            this.channel = channel;
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 0));
            this.btnVolume.setIcon(Res.iconVolume14);
            this.btnVolume.setIconTextGap(2);
            this.btnVolume.setAlignmentX(1.0f);
            this.btnVolume.setHorizontalAlignment(2);
            this.updateVolumeInfo(100);
            Dimension dimension = this.btnVolume.getPreferredSize();
            dimension.width = 57;
            this.btnVolume.setPreferredSize(dimension);
            this.btnVolume.setMinimumSize(dimension);
            this.add(this.btnVolume);
            this.btnVolume.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (popupVolume.isVisible()) {
                        popupVolume.commit();
                        popupVolume.hide();
                    } else {
                        float f = channel.getModel().getChannelInfo().getVolume();
                        popupVolume.setCurrentVolume(f);
                        popupVolume.show();
                    }
                }
            });
            this.popupVolume = new JSVolumeEditorPopup(this.btnVolume, JSVolumeEditorPopup.VolumeType.CHANNEL);
            this.popupVolume.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    channel.getModel().setBackendVolume(popupVolume.getVolumeFactor());
                }
            });
            this.btnVolume.addMouseListener(channel.getContextMenu());
        }

        public void updateVolumeInfo(int n) {
            if (CC.getViewConfig().isMeasurementUnitDecibel()) {
                String string = numberFormat.format(HF.percentsToDecibels(n));
                this.btnVolume.setText(string + "dB");
            } else {
                this.btnVolume.setText(String.valueOf(n) + "%");
            }
        }

        static {
            numberFormat.setMaximumFractionDigits(1);
        }
    }

    public static class StreamVoiceCountPane
    extends JPanel {
        private final Channel channel;
        private final JLabel lStreams = FantasiaUtils.createScreenLabel(" --");
        private final JLabel lSlash = FantasiaUtils.createScreenLabel("/");
        private final JLabel lVoices = FantasiaUtils.createScreenLabel("-- ");

        public StreamVoiceCountPane(Channel channel) {
            this.channel = channel;
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 0));
            this.lStreams.setFont(Res.fontScreenMono);
            this.lStreams.setHorizontalAlignment(4);
            this.lStreams.setToolTipText(FantasiaI18n.i18n.getLabel("Channel.streamVoiceCount"));
            Dimension dimension = this.lStreams.getPreferredSize();
            this.lStreams.setMinimumSize(dimension);
            this.lStreams.setPreferredSize(dimension);
            this.lStreams.setMaximumSize(dimension);
            this.add(this.lStreams);
            this.lSlash.setFont(Res.fontScreenMono);
            this.lSlash.setToolTipText(FantasiaI18n.i18n.getLabel("Channel.streamVoiceCount"));
            this.add(this.lSlash);
            this.lVoices.setFont(Res.fontScreenMono);
            this.lVoices.setToolTipText(FantasiaI18n.i18n.getLabel("Channel.streamVoiceCount"));
            dimension = this.lStreams.getPreferredSize();
            this.lVoices.setMinimumSize(dimension);
            this.lVoices.setPreferredSize(dimension);
            this.lVoices.setMaximumSize(dimension);
            this.add(this.lVoices);
            this.lStreams.addMouseListener(channel.getContextMenu());
            this.lSlash.addMouseListener(channel.getContextMenu());
            this.lVoices.addMouseListener(channel.getContextMenu());
        }

        public void updateStreamCount(int n) {
            this.lStreams.setText(n == 0 ? " --" : String.valueOf(n));
        }

        public void updateVoiceCount(int n) {
            this.lVoices.setText(n == 0 ? "-- " : String.valueOf(n));
        }
    }

    class FxSendsPane
    extends JSFxSendsPane {
        FxSendsPane(SamplerChannelModel samplerChannelModel) {
            super(samplerChannelModel);
            this.actionAddFxSend.putValue("SmallIcon", Res.iconNew16);
            this.actionRemoveFxSend.putValue("SmallIcon", Res.iconDelete16);
        }

        @Override
        protected JToolBar createToolBar() {
            JToolBar jToolBar = new JToolBar();
            Dimension dimension = new Dimension(Short.MAX_VALUE, jToolBar.getPreferredSize().height);
            jToolBar.setMaximumSize(dimension);
            jToolBar.setFloatable(false);
            jToolBar.setAlignmentX(1.0f);
            jToolBar.add(new ToolbarButton(this.actionAddFxSend));
            jToolBar.add(new ToolbarButton(this.actionRemoveFxSend));
            return jToolBar;
        }
    }

    class ContextMenu
    extends MouseAdapter {
        private JPopupMenu menu = null;

        ContextMenu() {
        }

        private void createMenu() {
            this.menu = new JPopupMenu();
            this.menu.add(new JMenuItem(new EditInstrumentAction()));
            this.menu.addSeparator();
            MenuManager.ChannelViewGroup channelViewGroup = new MenuManager.ChannelViewGroup(true, true);
            MenuManager.getMenuManager().registerChannelViewGroup(channelViewGroup);
            for (JRadioButtonMenuItem jRadioButtonMenuItem : channelViewGroup.getMenuItems()) {
                this.menu.add(jRadioButtonMenuItem);
            }
            this.menu.addSeparator();
            this.menu.add(new JMenuItem(A4n.a4n.moveChannelsOnTop));
            this.menu.add(new JMenuItem(A4n.a4n.moveChannelsUp));
            this.menu.add(new JMenuItem(A4n.a4n.moveChannelsDown));
            this.menu.add(new JMenuItem(A4n.a4n.moveChannelsAtBottom));
            this.menu.add(new MainFrame.ToPanelMenu());
            this.menu.addSeparator();
            this.menu.add(new JMenuItem(new FxSendsAction()));
            this.menu.add(new JMenuItem(new ChannelRoutingAction()));
        }

        private JPopupMenu getMenu() {
            if (this.menu == null) {
                this.createMenu();
            }
            return this.menu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        void show(MouseEvent mouseEvent) {
            this.getMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class ChannelRoutingAction
    extends AbstractAction
    implements SamplerChannelListener {
        ChannelRoutingAction() {
            super(FantasiaI18n.i18n.getMenuLabel("channels.channelRouting"));
            this.channelChanged(null);
            Channel.this.getModel().addSamplerChannelListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SamplerChannel samplerChannel = Channel.this.getChannelInfo();
            new JSChannelOutputRoutingDlg((Frame)CC.getMainFrame(), samplerChannel).setVisible(true);
        }

        @Override
        public void channelChanged(SamplerChannelEvent samplerChannelEvent) {
            boolean bl = Channel.this.getChannelInfo().getAudioOutputDevice() != -1;
            this.setEnabled(bl);
        }

        @Override
        public void streamCountChanged(SamplerChannelEvent samplerChannelEvent) {
        }

        @Override
        public void voiceCountChanged(SamplerChannelEvent samplerChannelEvent) {
        }
    }

    class FxSendsAction
    extends AbstractAction {
        FxSendsAction() {
            super(FantasiaI18n.i18n.getMenuLabel("channels.fxSends"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Channel.this.showFxSendsDialog();
        }
    }

    class EditInstrumentAction
    extends AbstractAction
    implements SamplerChannelListener {
        EditInstrumentAction() {
            super(FantasiaI18n.i18n.getMenuLabel("channels.editInstrument"));
            this.channelChanged(null);
            Channel.this.getModel().addSamplerChannelListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CC.getSamplerModel().editBackendInstrument(Channel.this.getChannelId());
        }

        @Override
        public void channelChanged(SamplerChannelEvent samplerChannelEvent) {
            boolean bl = Channel.this.getChannelInfo().getInstrumentStatus() == 100;
            this.setEnabled(bl);
        }

        @Override
        public void streamCountChanged(SamplerChannelEvent samplerChannelEvent) {
        }

        @Override
        public void voiceCountChanged(SamplerChannelEvent samplerChannelEvent) {
        }
    }

    class ViewTracker
    extends MouseAdapter
    implements PropertyChangeListener {
        private ChannelView originalView;
        private ChannelView mouseOverView;
        private ChannelView currentView;
        private ChannelView.Type mouseOverViewType = null;

        ViewTracker() {
            this.updateMouseOverViewType();
            String string = "differentChannelViewOnMO";
            FantasiaPrefs.preferences().addPropertyChangeListener(string, this);
            string = "channelViewOnMouseOver";
            FantasiaPrefs.preferences().addPropertyChangeListener(string, this);
        }

        public boolean isUsingOriginalView() {
            return this.currentView == this.originalView;
        }

        private void installListeners() {
        }

        private void uninstallListeners() {
        }

        private void updateMouseOverViewType() {
            if (this.mouseOverView != null) {
                this.mouseOverView.removeEnhancedMouseListener(this);
            }
            this.mouseOverView = null;
            boolean bl = FantasiaPrefs.preferences().getBoolProperty("differentChannelViewOnMO");
            if (!bl) {
                this.mouseOverViewType = null;
                this.uninstallListeners();
                return;
            }
            int n = FantasiaPrefs.preferences().getIntProperty("channelViewOnMouseOver");
            switch (n) {
                case 0: {
                    this.mouseOverViewType = ChannelView.Type.SMALL;
                    break;
                }
                case 1: {
                    this.mouseOverViewType = ChannelView.Type.NORMAL;
                    break;
                }
                default: {
                    this.mouseOverViewType = null;
                }
            }
            if (this.mouseOverViewType != null) {
                this.installListeners();
            }
        }

        public ChannelView getMouseOverView() {
            if (this.mouseOverViewType == null) {
                return null;
            }
            if (this.mouseOverView == null) {
                Channel channel = Channel.this;
                switch (this.mouseOverViewType) {
                    case SMALL: {
                        this.mouseOverView = new SmallChannelView(channel);
                        break;
                    }
                    case NORMAL: {
                        this.mouseOverView = new NormalChannelView(channel);
                        break;
                    }
                    default: {
                        this.mouseOverView = new NormalChannelView(channel);
                    }
                }
                this.mouseOverView.addEnhancedMouseListener(this);
            }
            return this.mouseOverView;
        }

        public ChannelView getCurrentView() {
            return this.currentView;
        }

        public ChannelView getOriginalView() {
            return this.originalView;
        }

        public void setView(ChannelView channelView) {
            this.setView(channelView, true);
        }

        public void setView(ChannelView channelView, boolean bl) {
            boolean bl2 = false;
            if (this.currentView != null) {
                bl2 = this.currentView.isOptionsButtonSelected();
            }
            if (bl) {
                if (this.originalView != null) {
                    this.originalView.removeEnhancedMouseListener(this);
                }
                if (this.originalView != this.currentView) {
                    this.destroyOriginalView();
                }
                if (this.currentView != null && this.currentView.getType() == channelView.getType()) {
                    this.originalView = this.currentView;
                    this.originalView.addEnhancedMouseListener(this);
                    this.destroyView(channelView);
                    return;
                }
                this.removeCurrentView();
                this.originalView = channelView;
                this.originalView.addEnhancedMouseListener(this);
                this.currentView = channelView;
            } else {
                if (channelView.getType() == this.getCurrentView().getType()) {
                    this.destroyView(channelView);
                    return;
                }
                this.removeCurrentView();
                this.currentView = channelView;
            }
            this.currentView.setOptionsButtonSelected(bl2);
            this.updateView();
        }

        private void updateView() {
            ChannelOptionsView channelOptionsView = this.getCurrentView().getChannelOptionsView();
            if (channelOptionsView != null) {
                Channel.this.optionsPane.setContentPane(channelOptionsView.getComponent());
            }
            Channel.this.updateChannelInfo();
            Channel.this.mainPane.add(this.getCurrentView().getComponent());
            Channel.this.mainPane.add(Channel.this.optionsPane);
            Channel.this.mainPane.validate();
            Channel.this.mainPane.revalidate();
            Channel.this.mainPane.repaint();
        }

        public void fallbackToOriginalView() {
            if (this.currentView == this.originalView) {
                return;
            }
            boolean bl = false;
            if (this.currentView != null) {
                bl = this.currentView.isOptionsButtonSelected();
            }
            this.removeCurrentView();
            this.currentView = this.originalView;
            this.currentView.setOptionsButtonSelected(bl);
            this.updateView();
        }

        private void removeCurrentView() {
            this.removeView(this.currentView);
        }

        private void destroyCurrentView() {
            this.destroyView(this.currentView);
        }

        private void removeOriginalView() {
            this.removeView(this.originalView);
        }

        private void destroyOriginalView() {
            this.destroyView(this.originalView);
        }

        private void removeView(ChannelView channelView) {
            if (channelView == null) {
                return;
            }
            Channel.this.mainPane.remove(channelView.getComponent());
            Channel.this.mainPane.remove(Channel.this.optionsPane);
            this.destroyView(channelView);
        }

        private void destroyView(ChannelView channelView) {
            if (channelView == null) {
                return;
            }
            channelView.uninstallView();
            channelView = null;
        }

        public boolean isMouseOverEnabled() {
            return this.mouseOverViewType != null;
        }

        private void mouseEntered() {
            JSChannel[] jSChannelArray;
            if (!this.isMouseOverEnabled()) {
                return;
            }
            if (this.getCurrentView().getType() == this.getMouseOverView().getType()) {
                return;
            }
            for (JSChannel jSChannel : jSChannelArray = CC.getMainFrame().getChannelsPane(0).getChannels()) {
                Channel channel;
                if (jSChannel == Channel.this || (channel = (Channel)jSChannel).isUsingOriginalView()) continue;
                channel.fallbackToOriginalView();
            }
            this.setView(this.getMouseOverView(), false);
        }

        private void mouseExited() {
            if (!this.isMouseOverEnabled()) {
                return;
            }
            if (this.getCurrentView().getType() == this.originalView.getType()) {
                return;
            }
            this.fallbackToOriginalView();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            guiListener.actionPerformed(null);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            guiListener.actionPerformed(null);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            mousePressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            mousePressed = false;
        }

        public void onDestroy() {
            this.destroyCurrentView();
            this.destroyOriginalView();
            this.uninstallListeners();
            if (this.currentView != null) {
                this.currentView.removeEnhancedMouseListener(this);
            }
            if (this.mouseOverView != null) {
                this.mouseOverView.removeEnhancedMouseListener(this);
            }
            String string = "differentChannelViewOnMO";
            FantasiaPrefs.preferences().removePropertyChangeListener(string, this);
            string = "channelViewOnMouseOver";
            FantasiaPrefs.preferences().removePropertyChangeListener(string, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateMouseOverViewType();
        }
    }

    private class EventHandler
    implements SamplerChannelListener,
    SamplerChannelListListener,
    PropertyChangeListener {
        private EventHandler() {
        }

        @Override
        public void channelChanged(SamplerChannelEvent samplerChannelEvent) {
            Channel.this.updateChannelInfo();
        }

        @Override
        public void streamCountChanged(SamplerChannelEvent samplerChannelEvent) {
            Channel.this.viewTracker.getCurrentView().updateStreamCount(Channel.this.getModel().getStreamCount());
        }

        @Override
        public void voiceCountChanged(SamplerChannelEvent samplerChannelEvent) {
            Channel.this.viewTracker.getCurrentView().updateVoiceCount(Channel.this.getModel().getVoiceCount());
        }

        @Override
        public void channelAdded(SamplerChannelListEvent samplerChannelListEvent) {
        }

        @Override
        public void channelRemoved(SamplerChannelListEvent samplerChannelListEvent) {
            if (samplerChannelListEvent.getChannelModel().getChannelId() == Channel.this.getChannelId()) {
                Channel.this.onDestroy();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getNewValue() == "collapsed") {
                CC.getSamplerModel().removeBackendChannel(Channel.this.getChannelId());
            }
        }
    }

    class AnimatedPorpetyListener
    implements PropertyChangeListener {
        AnimatedPorpetyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Channel.this.mainPane.setAnimated(FantasiaPrefs.preferences().getBoolProperty("animated"));
        }
    }
}

