/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;

public class Integer
extends ImmutableLiteral {
    public final int value;

    public Integer(int val) {
        this.value = val;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.INTEGER;
    }

    public Object createCacheObject(ThreadContext context) {
        return this.value;
    }

    public int hashCode() {
        return 47 * this.value;
    }

    public boolean equals(Object other) {
        return other instanceof Fixnum && (long)this.value == ((Fixnum)other).value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Integer(this);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.value);
    }

    public static Integer decode(IRReaderDecoder d) {
        return new Integer(d.decodeInt());
    }

    public String toString() {
        return "Integer:" + this.value;
    }

    @Override
    public boolean isTruthyImmediate() {
        return true;
    }
}

