/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NOperandResultBaseInstr;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Integer;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Stringable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RuntimeHelperCall
extends NOperandResultBaseInstr {
    final Methods helperMethod;

    public RuntimeHelperCall(Variable result2, Methods helperMethod, Operand[] args2) {
        super(Operation.RUNTIME_HELPER, result2, args2);
        this.helperMethod = helperMethod;
    }

    public Operand[] getArgs() {
        return this.getOperands();
    }

    public Methods getHelperMethod() {
        return this.helperMethod;
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        boolean modifiedScope = false;
        if (this.helperMethod == Methods.IS_DEFINED_SUPER) {
            modifiedScope = true;
            flags2.add(IRFlags.REQUIRES_CLASS);
        }
        return modifiedScope;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        Variable var = this.getResult();
        return new RuntimeHelperCall(var == null ? null : ii.getRenamedVariable(var), this.helperMethod, this.cloneOperands(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getHelperMethod().ordinal());
        e.encode(this.getArgs());
    }

    public static RuntimeHelperCall decode(IRReaderDecoder d) {
        return new RuntimeHelperCall(d.decodeVariable(), Methods.fromOrdinal(d.decodeInt()), d.decodeOperandArray());
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"method: " + String.valueOf((Object)this.helperMethod)};
    }

    public Object callHelper(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        Operand[] operands = this.getOperands();
        switch (this.helperMethod.ordinal()) {
            case 16: {
                return context.setErrorInfo((IRubyObject)operands[0].retrieve(context, self2, currScope, currDynScope, temp));
            }
            case 3: {
                return IRRuntimeHelpers.isDefinedBackref(context, (IRubyObject)operands[0].retrieve(context, self2, currScope, currDynScope, temp));
            }
            case 4: {
                return IRRuntimeHelpers.isDefinedNthRef(context, (int)((Fixnum)operands[0]).getValue(), (IRubyObject)operands[1].retrieve(context, self2, currScope, currDynScope, temp));
            }
            case 5: {
                return IRRuntimeHelpers.isDefinedGlobal(context, ((Stringable)((Object)operands[0])).getString(), (IRubyObject)operands[1].retrieve(context, self2, currScope, currDynScope, temp));
            }
            case 15: {
                IRRuntimeHelpers.traceRescue(context, ((Stringable)((Object)operands[0])).getString(), (int)((Integer)operands[1]).getValue());
                return context.nil;
            }
        }
        Object arg1 = operands[0].retrieve(context, self2, currScope, currDynScope, temp);
        switch (this.helperMethod.ordinal()) {
            case 0: {
                return IRRuntimeHelpers.handlePropagatedBreak(context, currDynScope, arg1);
            }
            case 1: {
                return IRRuntimeHelpers.handleNonlocalReturn(currDynScope, arg1);
            }
            case 2: {
                return IRRuntimeHelpers.handleBreakAndReturnsInLambdas(context, currDynScope, arg1, block);
            }
            case 9: {
                return IRRuntimeHelpers.isDefinedCall(context, self2, (IRubyObject)arg1, ((Stringable)((Object)operands[1])).getString(), (IRubyObject)operands[2].retrieve(context, self2, currScope, currDynScope, temp));
            }
            case 10: {
                return IRRuntimeHelpers.isDefinedConstantOrMethod(context, (IRubyObject)arg1, (RubyString)((FrozenString)operands[1]).retrieve(context, self2, currScope, currDynScope, temp), (IRubyObject)operands[2].retrieve(context, self2, currScope, currDynScope, temp), (IRubyObject)operands[3].retrieve(context, self2, currScope, currDynScope, temp));
            }
            case 6: {
                return IRRuntimeHelpers.isDefinedClassVar(context, (RubyModule)arg1, ((Stringable)((Object)operands[1])).getString(), (IRubyObject)operands[2].retrieve(context, self2, currScope, currDynScope, temp));
            }
            case 7: {
                return IRRuntimeHelpers.isDefinedSuper(context, (IRubyObject)arg1, (IRubyObject)operands[1].retrieve(context, self2, currScope, currDynScope, temp));
            }
            case 8: {
                return IRRuntimeHelpers.isDefinedMethod(context, (IRubyObject)arg1, ((Stringable)((Object)operands[1])).getString(), ((Boolean)operands[2]).isTrue(), (IRubyObject)operands[3].retrieve(context, self2, currScope, currDynScope, temp));
            }
            case 11: {
                return IRRuntimeHelpers.mergeKeywordArguments(context, (IRubyObject)arg1, (IRubyObject)this.getArgs()[1].retrieve(context, self2, currScope, currDynScope, temp), this.getArgs()[2] == context.runtime.getIRManager().getTrue());
            }
            case 12: {
                return IRRuntimeHelpers.isHashEmpty(context, (IRubyObject)arg1);
            }
            case 13: {
                return IRRuntimeHelpers.hashCheck(context, (IRubyObject)arg1);
            }
            case 14: {
                return IRRuntimeHelpers.arrayLength((RubyArray)arg1);
            }
        }
        throw new RuntimeException("Unknown IR runtime helper method: " + String.valueOf((Object)this.helperMethod) + "; INSTR: " + String.valueOf(this));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.RuntimeHelperCall(this);
    }

    public static enum Methods {
        HANDLE_PROPAGATED_BREAK,
        HANDLE_NONLOCAL_RETURN,
        HANDLE_BREAK_AND_RETURNS_IN_LAMBDA,
        IS_DEFINED_BACKREF,
        IS_DEFINED_NTH_REF,
        IS_DEFINED_GLOBAL,
        IS_DEFINED_CLASS_VAR,
        IS_DEFINED_SUPER,
        IS_DEFINED_METHOD,
        IS_DEFINED_CALL,
        IS_DEFINED_CONSTANT_OR_METHOD,
        MERGE_KWARGS,
        IS_HASH_EMPTY,
        HASH_CHECK,
        ARRAY_LENGTH,
        TRACE_RESCUE,
        RESET_GVAR_UNDERSCORE;

        private static final Methods[] VALUES;

        static Methods fromOrdinal(int value2) {
            return value2 < 0 || value2 >= VALUES.length ? null : VALUES[value2];
        }

        static {
            VALUES = Methods.values();
        }
    }
}

