/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.StringParser;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImageryReader
implements Closeable {
    private final String source;
    private CachedFile cachedFile;
    private boolean fastFail;

    public ImageryReader(String source) {
        this.source = source;
    }

    public List<ImageryInfo> parse() throws SAXException, IOException {
        List<ImageryInfo> list;
        block9: {
            Parser parser = new Parser();
            this.cachedFile = new CachedFile(this.source);
            this.cachedFile.setParam(String.join((CharSequence)",", ImageryInfo.getActiveIds()));
            this.cachedFile.setFastFail(this.fastFail);
            BufferedReader in = this.cachedFile.setMaxAge(CachedFile.DAYS).setCachingStrategy(CachedFile.CachingStrategy.IfModifiedSince).getContentReader();
            try {
                InputSource is = new InputSource(in);
                XmlUtils.parseSafeSAX(is, parser);
                list = parser.entries;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SAXException e) {
                    throw e;
                }
                catch (ParserConfigurationException e) {
                    Logging.error(e);
                    throw new SAXException(e);
                }
            }
            in.close();
        }
        return list;
    }

    public void setFastFail(boolean fastFail) {
        this.fastFail = fastFail;
    }

    @Override
    public void close() throws IOException {
        Utils.close(this.cachedFile);
    }

    private static final class Parser
    extends DefaultHandler {
        private static final String MAX_ZOOM = "max-zoom";
        private static final String MIN_ZOOM = "min-zoom";
        private static final String TILE_SIZE = "tile-size";
        private static final String PRIVACY_POLICY_URL = "privacy-policy-url";
        private static final String TRUE = "true";
        private StringBuilder accumulator = new StringBuilder();
        private Stack<State> states;
        private List<ImageryInfo> entries;
        private boolean skipEntry;
        private ImageryInfo entry;
        private ImageryInfo mirrorEntry;
        private ImageryInfo.ImageryBounds bounds;
        private final Map<ImageryInfo.ImageryBounds, ImageryInfo.ImageryBounds> boundsInterner = new HashMap<ImageryInfo.ImageryBounds, ImageryInfo.ImageryBounds>();
        private Shape shape;
        private String lang;
        private List<String> projections;
        private MultiMap<String, String> noTileHeaders;
        private MultiMap<String, String> noTileChecksums;
        private Map<String, String> metadataHeaders;
        private List<DefaultLayer> defaultLayers;
        private Map<String, String> customHttpHeaders;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuilder();
            this.skipEntry = false;
            this.states = new Stack();
            this.states.push(State.INIT);
            this.entries = new ArrayList<ImageryInfo>();
            this.entry = null;
            this.bounds = null;
            this.projections = null;
            this.noTileHeaders = null;
            this.noTileChecksums = null;
            this.customHttpHeaders = null;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.accumulator.setLength(0);
            State newState = null;
            switch (this.states.peek()) {
                case INIT: {
                    if (!"imagery".equals(qName)) break;
                    newState = State.IMAGERY;
                    break;
                }
                case IMAGERY: {
                    String overlay;
                    if (!"entry".equals(qName)) break;
                    this.entry = new ImageryInfo();
                    this.skipEntry = false;
                    newState = State.ENTRY;
                    this.noTileHeaders = new MultiMap();
                    this.noTileChecksums = new MultiMap();
                    this.metadataHeaders = new ConcurrentHashMap<String, String>();
                    this.defaultLayers = new ArrayList<DefaultLayer>();
                    this.customHttpHeaders = new ConcurrentHashMap<String, String>();
                    String best = atts.getValue("eli-best");
                    if (TRUE.equals(best)) {
                        this.entry.setBestMarked(true);
                    }
                    if (!TRUE.equals(overlay = atts.getValue("overlay"))) break;
                    this.entry.setOverlay(true);
                    break;
                }
                case MIRROR: {
                    if (Arrays.asList("type", "url", "id", MIN_ZOOM, MAX_ZOOM, PRIVACY_POLICY_URL, TILE_SIZE).contains(qName)) {
                        newState = State.MIRROR_ATTRIBUTE;
                        this.lang = atts.getValue("lang");
                        break;
                    }
                    if (!"projections".equals(qName)) break;
                    this.projections = new ArrayList<String>();
                    newState = State.MIRROR_PROJECTIONS;
                    break;
                }
                case ENTRY: {
                    if (Arrays.asList("name", "id", "oldid", "type", "description", "default", "url", "eula", MIN_ZOOM, MAX_ZOOM, "attribution-text", "attribution-url", "logo-image", "logo-url", "terms-of-use-text", "terms-of-use-url", PRIVACY_POLICY_URL, "permission-ref", "country-code", "category", "icon", "date", TILE_SIZE, "valid-georeference", "mod-tile-features", "transparent", "minimum-tile-expire").contains(qName)) {
                        newState = State.ENTRY_ATTRIBUTE;
                        this.lang = atts.getValue("lang");
                        break;
                    }
                    if ("bounds".equals(qName)) {
                        try {
                            this.bounds = new ImageryInfo.ImageryBounds(atts.getValue("min-lat") + "," + atts.getValue("min-lon") + "," + atts.getValue("max-lat") + "," + atts.getValue("max-lon"), ",");
                        }
                        catch (IllegalArgumentException e) {
                            Logging.trace(e);
                            break;
                        }
                        newState = State.BOUNDS;
                        break;
                    }
                    if ("projections".equals(qName)) {
                        this.projections = new ArrayList<String>();
                        newState = State.PROJECTIONS;
                        break;
                    }
                    if ("mirror".equals(qName)) {
                        this.projections = new ArrayList<String>();
                        newState = State.MIRROR;
                        this.mirrorEntry = new ImageryInfo();
                        break;
                    }
                    if ("no-tile-header".equals(qName)) {
                        this.noTileHeaders.put(atts.getValue("name"), atts.getValue("value"));
                        newState = State.NO_TILE;
                        break;
                    }
                    if ("no-tile-checksum".equals(qName)) {
                        this.noTileChecksums.put(atts.getValue("type"), atts.getValue("value"));
                        newState = State.NO_TILESUM;
                        break;
                    }
                    if ("metadata-header".equals(qName)) {
                        this.metadataHeaders.put(atts.getValue("header-name"), atts.getValue("metadata-key"));
                        newState = State.METADATA;
                        break;
                    }
                    if ("default-layers".equals(qName)) {
                        newState = State.DEFAULT_LAYERS;
                        break;
                    }
                    if (!"custom-http-header".equals(qName)) break;
                    this.customHttpHeaders.put(atts.getValue("header-name"), atts.getValue("header-value"));
                    newState = State.CUSTOM_HTTP_HEADERS;
                    break;
                }
                case BOUNDS: {
                    if (!"shape".equals(qName)) break;
                    this.shape = new Shape();
                    newState = State.SHAPE;
                    break;
                }
                case SHAPE: {
                    if (!"point".equals(qName)) break;
                    try {
                        this.shape.addPoint(atts.getValue("lat"), atts.getValue("lon"));
                    }
                    catch (IllegalArgumentException e) {
                        Logging.trace(e);
                    }
                    break;
                }
                case PROJECTIONS: 
                case MIRROR_PROJECTIONS: {
                    if (!"code".equals(qName)) break;
                    newState = State.CODE;
                    break;
                }
                case DEFAULT_LAYERS: {
                    if (!"layer".equals(qName)) break;
                    newState = State.NOOP;
                    try {
                        this.defaultLayers.add(new DefaultLayer(this.entry.getImageryType(), atts.getValue("name"), atts.getValue("style"), atts.getValue("tile-matrix-set")));
                    }
                    catch (IllegalArgumentException e) {
                        Logging.error(e);
                    }
                    break;
                }
            }
            if (newState == null) {
                newState = State.UNKNOWN;
            }
            this.states.push(newState);
            if (newState == State.UNKNOWN && TRUE.equals(atts.getValue("mandatory"))) {
                this.skipEntry = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.accumulator.append(ch, start, length);
        }

        @Override
        public void endElement(String namespaceURI, String qName, String rqName) {
            block0 : switch (this.states.pop()) {
                case INIT: {
                    throw new JosmRuntimeException("parsing error: more closing than opening elements");
                }
                case ENTRY: {
                    if (!"entry".equals(qName)) break;
                    this.entry.setNoTileHeaders(this.noTileHeaders);
                    this.noTileHeaders = null;
                    this.entry.setNoTileChecksums(this.noTileChecksums);
                    this.noTileChecksums = null;
                    this.entry.setMetadataHeaders(this.metadataHeaders);
                    this.metadataHeaders = null;
                    this.entry.setDefaultLayers(this.defaultLayers);
                    this.defaultLayers = null;
                    this.entry.setCustomHttpHeaders(this.customHttpHeaders);
                    this.customHttpHeaders = null;
                    if (!this.skipEntry) {
                        this.entries.add(this.entry);
                    }
                    this.entry = null;
                    break;
                }
                case MIRROR: {
                    if (this.mirrorEntry == null || !"mirror".equals(qName)) break;
                    this.entry.addMirror(this.mirrorEntry);
                    this.mirrorEntry = null;
                    break;
                }
                case MIRROR_ATTRIBUTE: {
                    if (this.mirrorEntry == null) break;
                    switch (qName) {
                        case "type": {
                            Optional<ImageryInfo.ImageryType> type = Arrays.stream(ImageryInfo.ImageryType.values()).filter(t -> Objects.equals(this.accumulator.toString(), t.getTypeString())).findFirst();
                            if (type.isPresent()) {
                                this.mirrorEntry.setImageryType(type.get());
                                break block0;
                            }
                            this.mirrorEntry = null;
                            break block0;
                        }
                        case "id": {
                            this.mirrorEntry.setId(this.accumulator.toString());
                            break block0;
                        }
                        case "url": {
                            this.mirrorEntry.setUrl(this.accumulator.toString());
                            break block0;
                        }
                        case "privacy-policy-url": {
                            this.mirrorEntry.setPrivacyPolicyURL(this.accumulator.toString());
                            break block0;
                        }
                        case "min-zoom": 
                        case "max-zoom": {
                            Optional<Integer> zoom = this.tryParseInt();
                            if (!zoom.isPresent()) {
                                this.mirrorEntry = null;
                                break block0;
                            }
                            if (MIN_ZOOM.equals(qName)) {
                                this.mirrorEntry.setDefaultMinZoom(zoom.get());
                                break block0;
                            }
                            this.mirrorEntry.setDefaultMaxZoom(zoom.get());
                            break block0;
                        }
                        case "tile-size": {
                            Optional<Integer> tileSize = this.tryParseInt();
                            if (!tileSize.isPresent()) {
                                this.mirrorEntry = null;
                                break block0;
                            }
                            this.entry.setTileSize(tileSize.get());
                            break block0;
                        }
                    }
                    break;
                }
                case ENTRY_ATTRIBUTE: {
                    switch (qName) {
                        case "name": {
                            this.entry.setName(this.lang == null ? LanguageInfo.getJOSMLocaleCode(null) : this.lang, this.accumulator.toString());
                            break block0;
                        }
                        case "description": {
                            this.entry.setDescription(this.lang, this.accumulator.toString());
                            break block0;
                        }
                        case "date": {
                            this.entry.setDate(this.accumulator.toString());
                            break block0;
                        }
                        case "id": {
                            this.entry.setId(this.accumulator.toString());
                            break block0;
                        }
                        case "oldid": {
                            this.entry.addOldId(this.accumulator.toString());
                            break block0;
                        }
                        case "type": {
                            ImageryInfo.ImageryType type = ImageryInfo.ImageryType.fromString(this.accumulator.toString());
                            if (type != null) {
                                this.entry.setImageryType(type);
                                break block0;
                            }
                            this.skipEntry = true;
                            break block0;
                        }
                        case "default": {
                            switch (this.accumulator.toString()) {
                                case "true": {
                                    this.entry.setDefaultEntry(true);
                                    break block0;
                                }
                                case "false": {
                                    this.entry.setDefaultEntry(false);
                                    break block0;
                                }
                            }
                            this.skipEntry = true;
                            break block0;
                        }
                        case "url": {
                            this.entry.setUrl(this.accumulator.toString());
                            break block0;
                        }
                        case "eula": {
                            this.entry.setEulaAcceptanceRequired(this.accumulator.toString());
                            break block0;
                        }
                        case "min-zoom": 
                        case "max-zoom": {
                            Optional<Integer> zoom = this.tryParseInt();
                            if (!zoom.isPresent()) {
                                this.skipEntry = true;
                                break block0;
                            }
                            if (MIN_ZOOM.equals(qName)) {
                                this.entry.setDefaultMinZoom(zoom.get());
                                break block0;
                            }
                            this.entry.setDefaultMaxZoom(zoom.get());
                            break block0;
                        }
                        case "attribution-text": {
                            this.entry.setAttributionText(this.accumulator.toString());
                            break block0;
                        }
                        case "attribution-url": {
                            this.entry.setAttributionLinkURL(this.accumulator.toString());
                            break block0;
                        }
                        case "logo-image": {
                            this.entry.setAttributionImage(this.accumulator.toString());
                            break block0;
                        }
                        case "logo-url": {
                            this.entry.setAttributionImageURL(this.accumulator.toString());
                            break block0;
                        }
                        case "terms-of-use-text": {
                            this.entry.setTermsOfUseText(this.accumulator.toString());
                            break block0;
                        }
                        case "privacy-policy-url": {
                            this.entry.setPrivacyPolicyURL(this.accumulator.toString());
                            break block0;
                        }
                        case "permission-ref": {
                            this.entry.setPermissionReferenceURL(this.accumulator.toString());
                            break block0;
                        }
                        case "terms-of-use-url": {
                            this.entry.setTermsOfUseURL(this.accumulator.toString());
                            break block0;
                        }
                        case "country-code": {
                            this.entry.setCountryCode(this.accumulator.toString());
                            break block0;
                        }
                        case "icon": {
                            this.entry.setIcon(this.accumulator.toString());
                            break block0;
                        }
                        case "tile-size": {
                            Optional<Integer> tileSize = this.tryParseInt();
                            if (!tileSize.isPresent()) {
                                this.skipEntry = true;
                                break block0;
                            }
                            this.entry.setTileSize(tileSize.get());
                            break block0;
                        }
                        case "valid-georeference": {
                            this.entry.setGeoreferenceValid(Boolean.parseBoolean(this.accumulator.toString()));
                            break block0;
                        }
                        case "mod-tile-features": {
                            this.entry.setModTileFeatures(Boolean.parseBoolean(this.accumulator.toString()));
                            break block0;
                        }
                        case "transparent": {
                            this.entry.setTransparent(Boolean.parseBoolean(this.accumulator.toString()));
                            break block0;
                        }
                        case "minimum-tile-expire": {
                            this.entry.setMinimumTileExpire(Integer.parseInt(this.accumulator.toString()));
                            break block0;
                        }
                        case "category": {
                            String cat = this.accumulator.toString();
                            ImageryInfo.ImageryCategory category = ImageryInfo.ImageryCategory.fromString(cat);
                            if (category != null) {
                                this.entry.setImageryCategory(category);
                            }
                            this.entry.setImageryCategoryOriginalString(cat);
                            break block0;
                        }
                    }
                    break;
                }
                case BOUNDS: {
                    this.entry.setBounds(this.intern(this.bounds));
                    this.bounds = null;
                    break;
                }
                case SHAPE: {
                    this.bounds.addShape(this.shape);
                    this.shape = null;
                    break;
                }
                case CODE: {
                    this.projections.add(this.accumulator.toString());
                    break;
                }
                case PROJECTIONS: {
                    this.entry.setServerProjections(this.projections);
                    this.projections = null;
                    break;
                }
                case MIRROR_PROJECTIONS: {
                    this.mirrorEntry.setServerProjections(this.projections);
                    this.projections = null;
                    break;
                }
            }
        }

        private ImageryInfo.ImageryBounds intern(ImageryInfo.ImageryBounds imageryBounds) {
            return this.boundsInterner.computeIfAbsent(imageryBounds, ignore -> imageryBounds);
        }

        private Optional<Integer> tryParseInt() {
            return StringParser.DEFAULT.tryParse(Integer.class, this.accumulator.toString());
        }
    }

    private static enum State {
        INIT,
        IMAGERY,
        ENTRY,
        ENTRY_ATTRIBUTE,
        PROJECTIONS,
        MIRROR,
        MIRROR_ATTRIBUTE,
        MIRROR_PROJECTIONS,
        CODE,
        BOUNDS,
        SHAPE,
        NO_TILE,
        NO_TILESUM,
        METADATA,
        DEFAULT_LAYERS,
        CUSTOM_HTTP_HEADERS,
        NOOP,
        UNKNOWN;

    }
}

