/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Feature;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Geometry;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;
import org.openstreetmap.josm.data.protobuf.ProtobufRecord;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;

public final class Layer
implements Destroyable {
    public static final byte LAYER_FIELD = 3;
    private static final byte VERSION_FIELD = 15;
    private static final byte NAME_FIELD = 1;
    private static final byte FEATURE_FIELD = 2;
    private static final byte KEY_FIELD = 3;
    private static final byte VALUE_FIELD = 4;
    private static final byte EXTENT_FIELD = 5;
    static final int DEFAULT_EXTENT = 4096;
    private static final byte DEFAULT_VERSION = 1;
    private final byte version;
    private final String name;
    private final int extent;
    private final List<String> keyList = new ArrayList<String>();
    private final List<Object> valueList = new ArrayList<Object>();
    private final List<Feature> featureCollection;

    public Layer(Collection<ProtobufRecord> records) throws IOException {
        HashMap sorted = new HashMap(records.size());
        byte tVersion = 1;
        String tName = null;
        int tExtent = 4096;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        for (ProtobufRecord protobufRecord : records) {
            if (protobufRecord.getField() == 15) {
                tVersion = protobufRecord.asUnsignedVarInt().byteValue();
                if (tVersion == 1 || tVersion == 2) continue;
                throw new IllegalArgumentException(I18n.tr("We do not understand version {0} of the vector tile specification", tVersion));
            }
            if (protobufRecord.getField() == 1) {
                tName = protobufRecord.asString();
                continue;
            }
            if (protobufRecord.getField() == 5) {
                tExtent = protobufRecord.asUnsignedVarInt().intValue();
                continue;
            }
            if (protobufRecord.getField() == 3) {
                this.keyList.add(protobufRecord.asString());
                continue;
            }
            if (protobufRecord.getField() == 4) {
                this.parseValueRecord(byteArrayOutputStream, protobufRecord);
                continue;
            }
            sorted.computeIfAbsent(protobufRecord.getField(), i -> new ArrayList(records.size())).add(protobufRecord);
        }
        this.version = tVersion;
        if (tName == null) {
            throw new IllegalArgumentException(I18n.tr("Vector tile layers must have a layer name", new Object[0]));
        }
        this.name = tName;
        this.extent = tExtent;
        this.featureCollection = new ArrayList<Feature>(sorted.getOrDefault(2, Collections.emptyList()).size());
        for (ProtobufRecord protobufRecord : sorted.getOrDefault(2, Collections.emptyList())) {
            this.featureCollection.add(new Feature(this, protobufRecord));
        }
        for (ProtobufRecord protobufRecord : records) {
            protobufRecord.close();
        }
    }

    private void parseValueRecord(ByteArrayOutputStream byteArrayOutputStream, ProtobufRecord protobufRecord) throws IOException {
        try (ProtobufParser parser = new ProtobufParser(protobufRecord.getBytes());){
            ProtobufRecord protobufRecord2 = new ProtobufRecord(byteArrayOutputStream, parser);
            int field = protobufRecord2.getField();
            int valueListSize = this.valueList.size();
            for (ValueFields<?> mapper : ValueFields.MAPPERS) {
                if (mapper.getField() != field) continue;
                this.valueList.add(mapper.convertValue(protobufRecord2));
                break;
            }
            if (valueListSize == this.valueList.size()) {
                throw new IllegalArgumentException(I18n.tr("Unknown field in vector tile layer value ({0})", field));
            }
        }
    }

    private static Collection<ProtobufRecord> getAllRecords(byte[] bytes) throws IOException {
        try (ProtobufParser parser = new ProtobufParser(bytes);){
            Collection<ProtobufRecord> collection = parser.allRecords();
            return collection;
        }
    }

    public Layer(byte[] bytes) throws IOException {
        this(Layer.getAllRecords(bytes));
    }

    public int getExtent() {
        return this.extent;
    }

    public Collection<Feature> getFeatures() {
        return Collections.unmodifiableCollection(this.featureCollection);
    }

    public Collection<Geometry> getGeometry() {
        return this.getFeatures().stream().map(Feature::getGeometryObject).collect(Collectors.toList());
    }

    public String getKey(int index) {
        return this.keyList.get(index);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(int index) {
        return this.valueList.get(index);
    }

    public byte getVersion() {
        return this.version;
    }

    @Override
    public void destroy() {
        this.featureCollection.clear();
        this.keyList.clear();
        this.valueList.clear();
    }

    public boolean equals(Object other) {
        if (other instanceof Layer) {
            Layer o = (Layer)other;
            return this.extent == o.extent && this.version == o.version && Objects.equals(this.name, o.name) && Objects.equals(this.featureCollection, o.featureCollection) && Objects.equals(this.keyList, o.keyList) && Objects.equals(this.valueList, o.valueList);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.extent, this.featureCollection, this.keyList, this.valueList);
    }

    private static final class ValueFields<T> {
        static final ValueFields<String> STRING = new ValueFields<String>(1, ProtobufRecord::asString);
        static final ValueFields<Float> FLOAT = new ValueFields<Float>(2, ProtobufRecord::asFloat);
        static final ValueFields<Double> DOUBLE = new ValueFields<Double>(3, ProtobufRecord::asDouble);
        static final ValueFields<Number> INT64 = new ValueFields<Number>(4, ProtobufRecord::asUnsignedVarInt);
        static final ValueFields<Number> UINT64 = new ValueFields<Number>(5, ProtobufRecord::asUnsignedVarInt);
        static final ValueFields<Number> SINT64 = new ValueFields<Number>(6, ProtobufRecord::asSignedVarInt);
        static final ValueFields<Boolean> BOOL = new ValueFields<Boolean>(7, r -> r.asUnsignedVarInt().longValue() != 0L);
        public static final Collection<ValueFields<?>> MAPPERS = Collections.unmodifiableList(Arrays.asList(STRING, FLOAT, DOUBLE, INT64, UINT64, SINT64, BOOL));
        private final byte field;
        private final Function<ProtobufRecord, T> conversion;

        private ValueFields(int field, Function<ProtobufRecord, T> conversion) {
            this.field = (byte)field;
            this.conversion = conversion;
        }

        public byte getField() {
            return this.field;
        }

        public T convertValue(ProtobufRecord protobufRecord) {
            return this.conversion.apply(protobufRecord);
        }
    }
}

