/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class Command
implements PseudoCommand {
    public static final int IS_OK = 0;
    public static final int IS_OUTSIDE = 1;
    public static final int IS_INCOMPLETE = 2;
    private Map<OsmPrimitive, PrimitiveData> cloneMap = Collections.emptyMap();
    private final DataSet data;

    protected Command(DataSet data) {
        CheckParameterUtil.ensureParameterNotNull(data, "data");
        this.data = data;
    }

    public boolean executeCommand() {
        CloneVisitor visitor = new CloneVisitor();
        ArrayList<OsmPrimitive> all = new ArrayList<OsmPrimitive>();
        this.fillModifiedData(all, all, all);
        for (OsmPrimitive osm : all) {
            osm.accept(visitor);
        }
        this.cloneMap = visitor.orig;
        return true;
    }

    public void undoCommand() {
        for (Map.Entry<OsmPrimitive, PrimitiveData> e : this.cloneMap.entrySet()) {
            OsmPrimitive primitive = e.getKey();
            if (primitive.getDataSet() == null) continue;
            e.getKey().load(e.getValue());
        }
    }

    public PrimitiveData getOrig(OsmPrimitive osm) {
        return this.cloneMap.get(osm);
    }

    public DataSet getAffectedDataSet() {
        return this.data;
    }

    public abstract void fillModifiedData(Collection<OsmPrimitive> var1, Collection<OsmPrimitive> var2, Collection<OsmPrimitive> var3);

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.cloneMap.keySet();
    }

    public static int checkOutlyingOrIncompleteOperation(Collection<? extends OsmPrimitive> primitives, Collection<? extends OsmPrimitive> ignore) {
        int res = 0;
        for (OsmPrimitive osmPrimitive : primitives) {
            if (osmPrimitive.isIncomplete()) {
                res |= 2;
                continue;
            }
            if ((res & 1) != 0 || osmPrimitive.isReferrersDownloaded() || ignore != null && ignore.contains(osmPrimitive)) continue;
            res |= 1;
        }
        return res;
    }

    protected void ensurePrimitivesAreInDataset() {
        for (OsmPrimitive osmPrimitive : this.getParticipatingPrimitives()) {
            if (osmPrimitive.getDataSet() != this.getAffectedDataSet()) {
                throw new AssertionError((Object)("Primitive is of wrong data set for this command: " + osmPrimitive));
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.cloneMap, this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Command command = (Command)obj;
        return Objects.equals(this.cloneMap, command.cloneMap) && Objects.equals(this.data, command.data);
    }

    public static class OldNodeState {
        private final LatLon latLon;
        private final EastNorth eastNorth;
        private final boolean modified;

        public OldNodeState(Node node) {
            this.latLon = node.getCoor();
            this.eastNorth = node.getEastNorth();
            this.modified = node.isModified();
        }

        public final LatLon getLatLon() {
            return this.latLon;
        }

        public final EastNorth getEastNorth() {
            return this.eastNorth;
        }

        public final boolean isModified() {
            return this.modified;
        }

        public int hashCode() {
            return Objects.hash(this.latLon, this.eastNorth, this.modified);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            OldNodeState that = (OldNodeState)obj;
            return this.modified == that.modified && Objects.equals(this.latLon, that.latLon) && Objects.equals(this.eastNorth, that.eastNorth);
        }
    }

    private static final class CloneVisitor
    implements OsmPrimitiveVisitor {
        final Map<OsmPrimitive, PrimitiveData> orig = new LinkedHashMap<OsmPrimitive, PrimitiveData>();

        private CloneVisitor() {
        }

        @Override
        public void visit(Node n) {
            this.orig.put(n, n.save());
        }

        @Override
        public void visit(Way w) {
            this.orig.put(w, w.save());
        }

        @Override
        public void visit(Relation e) {
            this.orig.put(e, e.save());
        }
    }
}

