/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Normalize an image by setting its mean to zero and variance to one.


NormalizeImageFilter shifts and scales an image so that the pixels in the image have a
zero mean and unit variance. This filter uses StatisticsImageFilter to compute the mean and variance of the input and then applies ShiftScaleImageFilter to shift and scale the pixels.

NB: since this filter normalizes the data such that the mean is at 0,
and $-\\sigma$ to $+\\sigma$ is mapped to -1.0 to 1.0, output image integral types will produce an
image that DOES NOT HAVE a unit variance due to 68% of the intensity
values being mapped to the real number range of -1.0 to 1.0 and then
cast to the output integral value.


See:
 NormalizeToConstantImageFilter

 itk::simple::Normalize for the procedural interface

 itk::NormalizeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkNormalizeImageFilter.h
*/
public class NormalizeImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected NormalizeImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.NormalizeImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(NormalizeImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(NormalizeImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::NormalizeImageFilter::~NormalizeImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_NormalizeImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::NormalizeImageFilter::NormalizeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  NormalizeImageFilter() {
    this(SimpleITKJNI.new_NormalizeImageFilter(), true);
  }

  /**
std::string itk::simple::NormalizeImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.NormalizeImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::NormalizeImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.NormalizeImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::NormalizeImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.NormalizeImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
