/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Base class for forward Fast Fourier Transform .


This is a base class for the "forward" or "direct" discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child class available on the system when the
object is created via the object factory system.

This class transforms a real input image into its full complex Fourier
transform. The Fourier transform of a real input image has Hermitian
symmetry: $ f(\\mathbf{x}) = f^*(-\\mathbf{x}) $ . That is, when the result of the transform is split in half along
the x-dimension, the values in the second half of the transform are
the complex conjugates of values in the first half reflected about the
center of the image in each dimension.

This filter works only for real single-component input image types.

The output generated from a ForwardFFTImageFilter is in the dual space or frequency domain. Refer to FrequencyFFTLayoutImageRegionConstIteratorWithIndex for a description of the layout of frequencies generated after a
forward FFT. Also see ITKImageFrequency for a set of filters requiring
input images in the frequency domain.


See:
 Forward1DFFTImageFilter

 InverseFFTImageFilter

 ComplexToComplexFFTImageFilter

 itk::simple::ForwardFFT for the procedural interface

 itk::ForwardFFTImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkForwardFFTImageFilter.h
*/
public class ForwardFFTImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ForwardFFTImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ForwardFFTImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ForwardFFTImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ForwardFFTImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ForwardFFTImageFilter::~ForwardFFTImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ForwardFFTImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ForwardFFTImageFilter::ForwardFFTImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ForwardFFTImageFilter() {
    this(SimpleITKJNI.new_ForwardFFTImageFilter(), true);
  }

  /**
std::string itk::simple::ForwardFFTImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ForwardFFTImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ForwardFFTImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ForwardFFTImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ForwardFFTImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ForwardFFTImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
