/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

binary morphological closing of an image.


This filter removes small (i.e., smaller than the structuring element)
objects in the image. It is defined as: Opening(f) =
ReconstructionByDilatation(Erosion(f)).

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
&gt; 0 are candidates for affecting the center pixel.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


See:
 MorphologyImageFilter , OpeningByReconstructionImageFilter , BinaryClosingByReconstructionImageFilter

 itk::simple::BinaryOpeningByReconstruction for the procedural interface

 itk::BinaryOpeningByReconstructionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryOpeningByReconstructionImageFilter.h
*/
public class BinaryOpeningByReconstructionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryOpeningByReconstructionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryOpeningByReconstructionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryOpeningByReconstructionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryOpeningByReconstructionImageFilter::~BinaryOpeningByReconstructionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryOpeningByReconstructionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryOpeningByReconstructionImageFilter::BinaryOpeningByReconstructionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryOpeningByReconstructionImageFilter() {
    this(SimpleITKJNI.new_BinaryOpeningByReconstructionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::BinaryOpeningByReconstructionImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::BinaryOpeningByReconstructionImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::BinaryOpeningByReconstructionImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as "foreground". Defaults to
maximum value of PixelType.

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryOpeningByReconstructionImageFilter::GetForegroundValue() const

Get the value in the image considered as "foreground". Defaults to
maximum value of PixelType.

*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryOpeningByReconstructionImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value in eroded part of the image. Defaults to zero

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::BinaryOpeningByReconstructionImageFilter::GetBackgroundValue() const

Set the value in eroded part of the image. Defaults to zero

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryOpeningByReconstructionImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::BinaryOpeningByReconstructionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryOpeningByReconstructionImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::BinaryOpeningByReconstructionImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryOpeningByReconstructionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryOpeningByReconstructionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryOpeningByReconstructionImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryOpeningByReconstructionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
