/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Label the connected components in a binary image and produce a collection
of label objects.


BinaryImageToLabelMapFilter labels the objects in a binary image. Each distinct object is
assigned a unique label. The final object labels start with 1 and are
consecutive. Objects that are reached earlier by a raster order scan
have a lower label.

The GetOutput() function of this class returns an itk::LabelMap .

This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ConnectedComponentImageFilter , LabelImageToLabelMapFilter , LabelMap , LabelObject

 itk::simple::BinaryImageToLabelMapFilter for the procedural interface

 itk::BinaryImageToLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryImageToLabelMapFilter.h
*/
public class BinaryImageToLabelMapFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryImageToLabelMapFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryImageToLabelMapFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryImageToLabelMapFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryImageToLabelMapFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryImageToLabelMapFilter::~BinaryImageToLabelMapFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryImageToLabelMapFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryImageToLabelMapFilter::BinaryImageToLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryImageToLabelMapFilter() {
    this(SimpleITKJNI.new_BinaryImageToLabelMapFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryImageToLabelMapFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.BinaryImageToLabelMapFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::BinaryImageToLabelMapFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.BinaryImageToLabelMapFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryImageToLabelMapFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.BinaryImageToLabelMapFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::BinaryImageToLabelMapFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.BinaryImageToLabelMapFilter_getFullyConnected(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryImageToLabelMapFilter::SetInputForegroundValue(double InputForegroundValue)

Set/Get the value to be consider "foreground" in the input image.
Defaults to NumericTraits&lt;InputPixelType&gt;::max() .

*/
public  void setInputForegroundValue(double InputForegroundValue) {
    SimpleITKJNI.BinaryImageToLabelMapFilter_setInputForegroundValue(swigCPtr, this, InputForegroundValue);
  }

  /**
double itk::simple::BinaryImageToLabelMapFilter::GetInputForegroundValue() const

Set/Get the value to be consider "foreground" in the input image.
Defaults to NumericTraits&lt;InputPixelType&gt;::max() .

*/
public  double getInputForegroundValue() {
    return SimpleITKJNI.BinaryImageToLabelMapFilter_getInputForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryImageToLabelMapFilter::SetOutputBackgroundValue(double OutputBackgroundValue)

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;OutputPixelType&gt;::NonpositiveMin() .

*/
public  void setOutputBackgroundValue(double OutputBackgroundValue) {
    SimpleITKJNI.BinaryImageToLabelMapFilter_setOutputBackgroundValue(swigCPtr, this, OutputBackgroundValue);
  }

  /**
double itk::simple::BinaryImageToLabelMapFilter::GetOutputBackgroundValue() const

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;OutputPixelType&gt;::NonpositiveMin() .

*/
public  double getOutputBackgroundValue() {
    return SimpleITKJNI.BinaryImageToLabelMapFilter_getOutputBackgroundValue(swigCPtr, this);
  }

  /**
uint64_t itk::simple::BinaryImageToLabelMapFilter::GetNumberOfObjects() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  java.math.BigInteger getNumberOfObjects() {
    return SimpleITKJNI.BinaryImageToLabelMapFilter_getNumberOfObjects(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryImageToLabelMapFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryImageToLabelMapFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryImageToLabelMapFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryImageToLabelMapFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryImageToLabelMapFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryImageToLabelMapFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
