/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

binary closing by reconstruction of an image.


This filter removes small (i.e., smaller than the structuring element)
holes in the image. It is defined as: Closing(f) =
ReconstructionByErosion(Dilation(f)).

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
&gt; 0 are candidates for affecting the center pixel.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


See:
 MorphologyImageFilter , ClosingByReconstructionImageFilter , BinaryOpeningByReconstructionImageFilter

 itk::simple::BinaryClosingByReconstruction for the procedural interface

 itk::BinaryClosingByReconstructionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryClosingByReconstructionImageFilter.h
*/
public class BinaryClosingByReconstructionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryClosingByReconstructionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryClosingByReconstructionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryClosingByReconstructionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryClosingByReconstructionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryClosingByReconstructionImageFilter::~BinaryClosingByReconstructionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryClosingByReconstructionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryClosingByReconstructionImageFilter::BinaryClosingByReconstructionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryClosingByReconstructionImageFilter() {
    this(SimpleITKJNI.new_BinaryClosingByReconstructionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.BinaryClosingByReconstructionImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.BinaryClosingByReconstructionImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::BinaryClosingByReconstructionImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.BinaryClosingByReconstructionImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.BinaryClosingByReconstructionImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::BinaryClosingByReconstructionImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.BinaryClosingByReconstructionImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::BinaryClosingByReconstructionImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as "foreground". Defaults to
maximum value of InputPixelType.

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryClosingByReconstructionImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryClosingByReconstructionImageFilter::GetForegroundValue() const

Get the value in the image considered as "foreground". Defaults to
maximum value of InputPixelType.

*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryClosingByReconstructionImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryClosingByReconstructionImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.BinaryClosingByReconstructionImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::BinaryClosingByReconstructionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.BinaryClosingByReconstructionImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryClosingByReconstructionImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.BinaryClosingByReconstructionImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::BinaryClosingByReconstructionImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.BinaryClosingByReconstructionImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryClosingByReconstructionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryClosingByReconstructionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryClosingByReconstructionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryClosingByReconstructionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryClosingByReconstructionImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryClosingByReconstructionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
