/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.observable.operation.OperationExecutionContext;
import com.intellij.openapi.observable.operation.OperationExecutionId;
import com.intellij.openapi.observable.operation.OperationExecutionStatus;
import com.intellij.openapi.observable.operation.core.AtomicOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTrace;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u001a*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000f0\u000e\u001a*\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00140\u000e\u001a(\u0010\u0016\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00140\u000e\u001a.\u0010\u0018\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u001e\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u0019\u001a\"\u0010\u001a\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00140\u001b\u001a4\u0010\u001d\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u001a\u0010\u0015\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00140\u000eH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"ID_KEY", "Lcom/intellij/openapi/observable/operation/OperationExecutionContext$ContextKey;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "PATH_KEY", "", "getGradleProjectReloadOperation", "Lcom/intellij/openapi/observable/operation/core/ObservableOperationTrace;", "externalProjectPath", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "getGradleTaskExecutionOperation", "isRelevant", "Lkotlin/Function2;", "", "isResolveTask", "id", "isExecuteTask", "whenExternalSystemTaskStarted", "", "action", "whenExternalSystemTaskFinished", "Lcom/intellij/openapi/observable/operation/OperationExecutionStatus;", "whenExternalSystemTaskOutputAdded", "Lkotlin/Function3;", "whenExternalSystemEventReceived", "Lkotlin/Function1;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationEvent;", "whenProjectDataLoadFinished", "intellij.gradle"})
@JvmName(name="GradleImportingUtil")
@ApiStatus.Internal
public final class GradleImportingUtil {
    @NotNull
    private static final OperationExecutionContext.ContextKey<ExternalSystemTaskId> ID_KEY = OperationExecutionContext.Companion.createKey("ID");
    @NotNull
    private static final OperationExecutionContext.ContextKey<String> PATH_KEY = OperationExecutionContext.Companion.createKey("PATH");

    @NotNull
    public static final ObservableOperationTrace getGradleProjectReloadOperation(@NotNull String externalProjectPath2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return GradleImportingUtil.getGradleProjectReloadOperation(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Boolean>)((Function2)(arg_0, arg_1) -> GradleImportingUtil.getGradleProjectReloadOperation$lambda$0(externalProjectPath2, arg_0, arg_1)));
    }

    @NotNull
    public static final ObservableOperationTrace getGradleProjectReloadOperation(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return GradleImportingUtil.getGradleProjectReloadOperation(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Boolean>)((Function2)(arg_0, arg_1) -> GradleImportingUtil.getGradleProjectReloadOperation$lambda$1(project2, arg_0, arg_1)));
    }

    @NotNull
    public static final ObservableOperationTrace getGradleProjectReloadOperation(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return GradleImportingUtil.getGradleProjectReloadOperation(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Boolean>)((Function2)GradleImportingUtil::getGradleProjectReloadOperation$lambda$2));
    }

    @NotNull
    public static final ObservableOperationTrace getGradleTaskExecutionOperation(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return GradleImportingUtil.getGradleTaskExecutionOperation(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Boolean>)((Function2)(arg_0, arg_1) -> GradleImportingUtil.getGradleTaskExecutionOperation$lambda$3(project2, arg_0, arg_1)));
    }

    @NotNull
    public static final ObservableOperationTrace getGradleTaskExecutionOperation(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return GradleImportingUtil.getGradleTaskExecutionOperation(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super String, Boolean>)((Function2)GradleImportingUtil::getGradleTaskExecutionOperation$lambda$4));
    }

    @NotNull
    public static final ObservableOperationTrace getGradleProjectReloadOperation(@NotNull Disposable parentDisposable, @NotNull Function2<? super ExternalSystemTaskId, ? super String, Boolean> isRelevant) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(isRelevant, (String)"isRelevant");
        AtomicOperationTrace operation = new AtomicOperationTrace("Gradle Reload");
        HashMap executionIds = new HashMap();
        GradleImportingUtil.whenExternalSystemTaskStarted(parentDisposable, (Function2<? super String, ? super ExternalSystemTaskId, Unit>)((Function2)(arg_0, arg_1) -> GradleImportingUtil.getGradleProjectReloadOperation$lambda$6(isRelevant, executionIds, operation, arg_0, arg_1)));
        GradleImportingUtil.whenExternalSystemTaskFinished(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super OperationExecutionStatus, Unit>)((Function2)(arg_0, arg_1) -> GradleImportingUtil.getGradleProjectReloadOperation$lambda$8(executionIds, operation, parentDisposable, isRelevant, arg_0, arg_1)));
        return (ObservableOperationTrace)operation;
    }

    @NotNull
    public static final ObservableOperationTrace getGradleTaskExecutionOperation(@NotNull Disposable parentDisposable, @NotNull Function2<? super ExternalSystemTaskId, ? super String, Boolean> isRelevant) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(isRelevant, (String)"isRelevant");
        AtomicOperationTrace operation = new AtomicOperationTrace("Gradle Task Execution");
        HashMap executionIds = new HashMap();
        GradleImportingUtil.whenExternalSystemTaskStarted(parentDisposable, (Function2<? super String, ? super ExternalSystemTaskId, Unit>)((Function2)(arg_0, arg_1) -> GradleImportingUtil.getGradleTaskExecutionOperation$lambda$10(isRelevant, executionIds, operation, arg_0, arg_1)));
        GradleImportingUtil.whenExternalSystemTaskFinished(parentDisposable, (Function2<? super ExternalSystemTaskId, ? super OperationExecutionStatus, Unit>)((Function2)(arg_0, arg_1) -> GradleImportingUtil.getGradleTaskExecutionOperation$lambda$11(executionIds, operation, arg_0, arg_1)));
        return (ObservableOperationTrace)operation;
    }

    public static final boolean isResolveTask(@NotNull ExternalSystemTaskId id) {
        ExternalSystemProcessingManager processingManager;
        ExternalSystemTask task2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT && (task2 = (processingManager = ExternalSystemProcessingManager.getInstance()).findTask(id)) instanceof ExternalSystemResolveProjectTask) {
            return !((ExternalSystemResolveProjectTask)task2).isPreviewMode();
        }
        return false;
    }

    private static final boolean isExecuteTask(ExternalSystemTaskId id) {
        return id.getType() == ExternalSystemTaskType.EXECUTE_TASK;
    }

    public static final void whenExternalSystemTaskStarted(@NotNull Disposable parentDisposable, @NotNull Function2<? super String, ? super ExternalSystemTaskId, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener(new ExternalSystemTaskNotificationListener(action){
            final /* synthetic */ Function2<String, ExternalSystemTaskId, Unit> $action;
            {
                this.$action = $action;
            }

            public void onStart(String projectPath, ExternalSystemTaskId id) {
                Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.$action.invoke((Object)projectPath, (Object)id);
            }
        }, parentDisposable);
    }

    public static final void whenExternalSystemTaskFinished(@NotNull Disposable parentDisposable, @NotNull Function2<? super ExternalSystemTaskId, ? super OperationExecutionStatus, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener(new ExternalSystemTaskNotificationListener(action){
            final /* synthetic */ Function2<ExternalSystemTaskId, OperationExecutionStatus, Unit> $action;
            {
                this.$action = $action;
            }

            public void onSuccess(String projectPath, ExternalSystemTaskId id) {
                Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.$action.invoke((Object)id, (Object)OperationExecutionStatus.Success.INSTANCE);
            }

            public void onFailure(String projectPath, ExternalSystemTaskId id, Exception exception) {
                Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.$action.invoke((Object)id, (Object)new OperationExecutionStatus.Failure((Throwable)exception));
            }

            public void onCancel(String projectPath, ExternalSystemTaskId id) {
                Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.$action.invoke((Object)id, (Object)OperationExecutionStatus.Cancel.INSTANCE);
            }
        }, parentDisposable);
    }

    public static final void whenExternalSystemTaskOutputAdded(@NotNull Disposable parentDisposable, @NotNull Function3<? super ExternalSystemTaskId, ? super String, ? super Boolean, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ExternalSystemTaskNotificationListener listener2 = new ExternalSystemTaskNotificationListener(action){
            final /* synthetic */ Function3<ExternalSystemTaskId, String, Boolean, Unit> $action;
            {
                this.$action = $action;
            }

            public void onTaskOutput(ExternalSystemTaskId id, String text, boolean stdOut) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$action.invoke((Object)id, (Object)text, (Object)stdOut);
            }
        };
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener(listener2, parentDisposable);
    }

    public static final void whenExternalSystemEventReceived(@NotNull Disposable parentDisposable, @NotNull Function1<? super ExternalSystemTaskNotificationEvent, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ExternalSystemTaskNotificationListener listener2 = new ExternalSystemTaskNotificationListener(action){
            final /* synthetic */ Function1<ExternalSystemTaskNotificationEvent, Unit> $action;
            {
                this.$action = $action;
            }

            public void onStatusChange(ExternalSystemTaskNotificationEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$action.invoke((Object)event);
            }
        };
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener(listener2, parentDisposable);
    }

    private static final void whenProjectDataLoadFinished(Project project2, Disposable parentDisposable, Function2<? super String, ? super OperationExecutionStatus, Unit> action) {
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect(parentDisposable);
        Topic topic = ProjectDataImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ProjectDataImportListener(action){
            final /* synthetic */ Function2<String, OperationExecutionStatus, Unit> $action;
            {
                this.$action = $action;
            }

            public void onImportFailed(String projectPath, Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$action.invoke((Object)projectPath, (Object)new OperationExecutionStatus.Failure(t));
            }

            public void onFinalTasksFinished(String projectPath) {
                this.$action.invoke((Object)projectPath, (Object)OperationExecutionStatus.Success.INSTANCE);
            }
        });
    }

    private static final boolean getGradleProjectReloadOperation$lambda$0(String $externalProjectPath, ExternalSystemTaskId externalSystemTaskId, String path) {
        Intrinsics.checkNotNullParameter((Object)externalSystemTaskId, (String)"<unused var>");
        return Intrinsics.areEqual((Object)path, (Object)$externalProjectPath);
    }

    private static final boolean getGradleProjectReloadOperation$lambda$1(Project $project, ExternalSystemTaskId id, String string) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Intrinsics.areEqual((Object)id.findProject(), (Object)$project);
    }

    private static final boolean getGradleProjectReloadOperation$lambda$2(ExternalSystemTaskId externalSystemTaskId, String string) {
        Intrinsics.checkNotNullParameter((Object)externalSystemTaskId, (String)"<unused var>");
        return true;
    }

    private static final boolean getGradleTaskExecutionOperation$lambda$3(Project $project, ExternalSystemTaskId id, String string) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Intrinsics.areEqual((Object)id.findProject(), (Object)$project);
    }

    private static final boolean getGradleTaskExecutionOperation$lambda$4(ExternalSystemTaskId externalSystemTaskId, String string) {
        Intrinsics.checkNotNullParameter((Object)externalSystemTaskId, (String)"<unused var>");
        return true;
    }

    private static final Unit getGradleProjectReloadOperation$lambda$6$lambda$5(ExternalSystemTaskId $id, String $path, OperationExecutionContext.Builder $this$createId) {
        Intrinsics.checkNotNullParameter((Object)$this$createId, (String)"$this$createId");
        $this$createId.putData(ID_KEY, (Object)$id);
        $this$createId.putData(PATH_KEY, (Object)$path);
        return Unit.INSTANCE;
    }

    private static final Unit getGradleProjectReloadOperation$lambda$6(Function2 $isRelevant, HashMap $executionIds, AtomicOperationTrace $operation, String path, ExternalSystemTaskId id) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (GradleImportingUtil.isResolveTask(id) && ((Boolean)$isRelevant.invoke((Object)id, (Object)path)).booleanValue()) {
            OperationExecutionId executionId = OperationExecutionId.Companion.createId$default((OperationExecutionId.Companion)OperationExecutionId.Companion, null, arg_0 -> GradleImportingUtil.getGradleProjectReloadOperation$lambda$6$lambda$5(id, path, arg_0), (int)1, null);
            ((Map)$executionIds).put(id, executionId);
            $operation.traceStart(executionId);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getGradleProjectReloadOperation$lambda$8$lambda$7(Function2 $isRelevant, ExternalSystemTaskId $id, Disposable $loadDisposable, AtomicOperationTrace $operation, OperationExecutionId $executionId, String path, OperationExecutionStatus loadStatus) {
        Intrinsics.checkNotNullParameter((Object)loadStatus, (String)"loadStatus");
        if (((Boolean)$isRelevant.invoke((Object)$id, (Object)path)).booleanValue()) {
            Disposer.dispose((Disposable)$loadDisposable);
            $operation.traceFinish($executionId, loadStatus);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getGradleProjectReloadOperation$lambda$8(HashMap $executionIds, AtomicOperationTrace $operation, Disposable $parentDisposable, Function2 $isRelevant, ExternalSystemTaskId id, OperationExecutionStatus status) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        OperationExecutionId executionId = (OperationExecutionId)$executionIds.remove(id);
        if (executionId != null) {
            if (!(status instanceof OperationExecutionStatus.Success)) {
                $operation.traceFinish(executionId, status);
                return Unit.INSTANCE;
            }
            Project project2 = id.findProject();
            if (project2 == null) {
                $operation.traceFinish(executionId, (OperationExecutionStatus)OperationExecutionStatus.Cancel.INSTANCE);
                return Unit.INSTANCE;
            }
            Disposable disposable = Disposer.newDisposable((Disposable)$parentDisposable);
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable loadDisposable = disposable;
            GradleImportingUtil.whenProjectDataLoadFinished(project2, loadDisposable, (Function2<? super String, ? super OperationExecutionStatus, Unit>)((Function2)(arg_0, arg_1) -> GradleImportingUtil.getGradleProjectReloadOperation$lambda$8$lambda$7($isRelevant, id, loadDisposable, $operation, executionId, arg_0, arg_1)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit getGradleTaskExecutionOperation$lambda$10$lambda$9(ExternalSystemTaskId $id, String $path, OperationExecutionContext.Builder $this$createId) {
        Intrinsics.checkNotNullParameter((Object)$this$createId, (String)"$this$createId");
        $this$createId.putData(ID_KEY, (Object)$id);
        $this$createId.putData(PATH_KEY, (Object)$path);
        return Unit.INSTANCE;
    }

    private static final Unit getGradleTaskExecutionOperation$lambda$10(Function2 $isRelevant, HashMap $executionIds, AtomicOperationTrace $operation, String path, ExternalSystemTaskId id) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (GradleImportingUtil.isExecuteTask(id) && ((Boolean)$isRelevant.invoke((Object)id, (Object)path)).booleanValue()) {
            OperationExecutionId executionId = OperationExecutionId.Companion.createId$default((OperationExecutionId.Companion)OperationExecutionId.Companion, null, arg_0 -> GradleImportingUtil.getGradleTaskExecutionOperation$lambda$10$lambda$9(id, path, arg_0), (int)1, null);
            ((Map)$executionIds).put(id, executionId);
            $operation.traceStart(executionId);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getGradleTaskExecutionOperation$lambda$11(HashMap $executionIds, AtomicOperationTrace $operation, ExternalSystemTaskId id, OperationExecutionStatus status) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        OperationExecutionId executionId = (OperationExecutionId)$executionIds.remove(id);
        if (executionId != null) {
            $operation.traceFinish(executionId, status);
        }
        return Unit.INSTANCE;
    }
}

