/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.Time;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.tooling.internal.consumer.DistributionInstaller;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.DistributionLocator;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.wrapper.PropertiesFileHandler;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class DistributionFactoryExt
extends DistributionFactory {
    private DistributionFactoryExt() {
        super(Time.clock());
    }

    public static void setWrappedDistribution(GradleConnector connector, String wrapperPropertyFile) {
        WrapperExecutor wrapper;
        File propertiesFile = new File(wrapperPropertyFile);
        if (propertiesFile.exists() && (wrapper = WrapperExecutor.forWrapperPropertiesFile((File)propertiesFile)).getDistribution() != null) {
            Distribution distribution = new DistributionFactoryExt().getWrappedDistribution(propertiesFile);
            try {
                DistributionFactoryExt.setDistributionField(connector, distribution);
            }
            catch (Exception e) {
                ExternalSystemException externalSystemException = new ExternalSystemException((Throwable)e);
                externalSystemException.initCause((Throwable)e);
                throw externalSystemException;
            }
        }
    }

    private Distribution getWrappedDistribution(File propertiesFile) {
        WrapperExecutor wrapper = WrapperExecutor.forWrapperPropertiesFile((File)propertiesFile);
        if (wrapper.getDistribution() != null) {
            return new ZippedDistribution(wrapper.getConfiguration(), Time.clock());
        }
        return this.getDownloadedDistribution(GradleVersion.current().getVersion());
    }

    private Distribution getDownloadedDistribution(String gradleVersion) {
        URI distUri = new DistributionLocator().getDistributionFor(GradleVersion.version((String)gradleVersion));
        return this.getDistribution(distUri);
    }

    private static void setDistributionField(GradleConnector connector, Object fieldValue) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = connector.getClass().getDeclaredField("distribution");
        boolean isAccessible = field.canAccess(connector);
        field.setAccessible(true);
        field.set(connector, fieldValue);
        field.setAccessible(isAccessible);
    }

    private static final class ZippedDistribution
    implements Distribution {
        private InstalledDistribution installedDistribution;
        private final WrapperConfiguration wrapperConfiguration;
        private final Clock clock;

        private ZippedDistribution(WrapperConfiguration wrapperConfiguration, Clock clock) {
            this.wrapperConfiguration = wrapperConfiguration;
            this.clock = clock;
        }

        public String getDisplayName() {
            return "Gradle distribution '" + this.wrapperConfiguration.getDistribution() + "'";
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, ConnectionParameters connectionParameters, BuildCancellationToken cancellationToken) {
            if (this.installedDistribution == null) {
                File installDir;
                DistributionInstaller installer = new DistributionInstaller(progressLoggerFactory, progressListener, this.clock);
                try {
                    cancellationToken.addCallback(() -> installer.cancel());
                    installDir = installer.install(ZippedDistribution.determineRealUserHomeDir(connectionParameters), ZippedDistribution.determineRootDir(connectionParameters), this.wrapperConfiguration, ZippedDistribution.determineSystemProperties(connectionParameters));
                }
                catch (CancellationException e) {
                    throw new BuildCancelledException(String.format("Distribution download cancelled. Using distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.getDisplayName()), e);
                }
                catch (Exception e) {
                    throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                }
                this.installedDistribution = new InstalledDistribution(installDir, this.getDisplayName(), this.getDisplayName());
            }
            return this.installedDistribution.getToolingImplementationClasspath(progressLoggerFactory, progressListener, connectionParameters, cancellationToken);
        }

        private static Map<String, String> determineSystemProperties(ConnectionParameters connectionParameters) {
            HashMap<String, String> systemProperties = new HashMap<String, String>();
            for (Map.Entry<Object, Object> objectEntry : System.getProperties().entrySet()) {
                systemProperties.put(objectEntry.getKey().toString(), objectEntry.getValue() == null ? null : objectEntry.getValue().toString());
            }
            systemProperties.putAll(PropertiesFileHandler.getSystemProperties((File)new File(ZippedDistribution.determineRootDir(connectionParameters), "gradle.properties")));
            systemProperties.putAll(PropertiesFileHandler.getSystemProperties((File)new File(ZippedDistribution.determineRealUserHomeDir(connectionParameters), "gradle.properties")));
            return systemProperties;
        }

        private static File determineRootDir(ConnectionParameters connectionParameters) {
            return new BuildLayoutFactory().getLayoutFor(connectionParameters.getProjectDir(), connectionParameters.isSearchUpwards() != null ? connectionParameters.isSearchUpwards() : true).getRootDirectory();
        }

        private static File determineRealUserHomeDir(ConnectionParameters connectionParameters) {
            File distributionBaseDir = connectionParameters.getDistributionBaseDir();
            if (distributionBaseDir != null) {
                return distributionBaseDir;
            }
            File userHomeDir = connectionParameters.getGradleUserHomeDir();
            return userHomeDir != null ? userHomeDir : GradleUserHomeLookup.gradleUserHome();
        }
    }

    private static class InstalledDistribution
    implements Distribution {
        private final File gradleHomeDir;
        private final String displayName;
        private final String locationDisplayName;

        InstalledDistribution(File gradleHomeDir, String displayName, String locationDisplayName) {
            this.gradleHomeDir = gradleHomeDir;
            this.displayName = displayName;
            this.locationDisplayName = locationDisplayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, ConnectionParameters connectionParameters, BuildCancellationToken cancellationToken) {
            if (!this.gradleHomeDir.exists()) {
                throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.locationDisplayName));
            }
            if (!this.gradleHomeDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s is not a directory.", this.locationDisplayName));
            }
            File libDir = new File(this.gradleHomeDir, "lib");
            if (!libDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s does not appear to contain a Gradle distribution.", this.locationDisplayName));
            }
            Object[] files = libDir.listFiles(file -> FileUtils.hasExtension((File)file, (String)".jar"));
            if (files != null) {
                Arrays.sort(files);
            }
            return DefaultClassPath.of((File[])files);
        }
    }
}

