/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.serialization.CannotLoadJpsModelException;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsElementExtensionSerializerBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionWithExternalDataSerializer;
import org.jetbrains.jps.model.serialization.impl.TimingLog;

@ApiStatus.Internal
public final class JpsComponentLoader {
    private static final Logger LOG = Logger.getInstance(JpsComponentLoader.class);
    private static final int MAX_ATTEMPTS = 5;
    @Nullable
    private final Path myExternalConfigurationDirectory;
    private final JpsMacroExpander myMacroExpander;
    private static final Element NULL_VALUE = new Element("null");
    private final ConcurrentHashMap<Path, Element> myRootElementsCache;

    public JpsComponentLoader(@NotNull JpsMacroExpander macroExpander, @Nullable Path externalConfigurationDirectory) {
        if (macroExpander == null) {
            JpsComponentLoader.$$$reportNull$$$0(0);
        }
        this(macroExpander, externalConfigurationDirectory, false);
    }

    public JpsComponentLoader(@NotNull JpsMacroExpander macroExpander, @Nullable Path externalConfigurationDirectory, boolean useCache) {
        if (macroExpander == null) {
            JpsComponentLoader.$$$reportNull$$$0(1);
        }
        this.myMacroExpander = macroExpander;
        this.myExternalConfigurationDirectory = externalConfigurationDirectory;
        this.myRootElementsCache = useCache ? new ConcurrentHashMap() : null;
    }

    @NotNull
    public JpsMacroExpander getMacroExpander() {
        JpsMacroExpander jpsMacroExpander = this.myMacroExpander;
        if (jpsMacroExpander == null) {
            JpsComponentLoader.$$$reportNull$$$0(2);
        }
        return jpsMacroExpander;
    }

    @Nullable
    public Element loadRootElement(@NotNull Path file) {
        if (file == null) {
            JpsComponentLoader.$$$reportNull$$$0(3);
        }
        if (this.myRootElementsCache == null) {
            return JpsComponentLoader.loadRootElement(file, this.myMacroExpander);
        }
        Element cached = this.myRootElementsCache.get(file);
        if (cached != null) {
            return cached != NULL_VALUE ? cached : null;
        }
        Element result = JpsComponentLoader.loadRootElement(file, this.myMacroExpander);
        this.myRootElementsCache.put(file, Objects.requireNonNullElse(result, NULL_VALUE));
        return result;
    }

    @Nullable
    public Element loadComponent(@NotNull Path file, @NotNull String componentName) {
        if (file == null) {
            JpsComponentLoader.$$$reportNull$$$0(4);
        }
        if (componentName == null) {
            JpsComponentLoader.$$$reportNull$$$0(5);
        }
        return JDomSerializationUtil.findComponent(this.loadRootElement(file), componentName);
    }

    public <E extends JpsElement> void loadComponents(@NotNull Path dir, @NotNull Path defaultConfigFile, JpsElementExtensionSerializerBase<E> serializer, E element) {
        String fileName;
        if (dir == null) {
            JpsComponentLoader.$$$reportNull$$$0(6);
        }
        if (defaultConfigFile == null) {
            JpsComponentLoader.$$$reportNull$$$0(7);
        }
        Path configFile = (fileName = serializer.getConfigFileName()) == null ? defaultConfigFile : dir.resolve(fileName);
        Runnable timingLog = TimingLog.startActivity("loading: " + configFile.getFileName() + ":" + serializer.getComponentName());
        Element componentTag = this.loadComponentData(serializer, configFile);
        if (componentTag != null) {
            serializer.loadExtension(element, componentTag);
        } else {
            serializer.loadExtensionWithDefaultSettings(element);
        }
        timingLog.run();
    }

    @Nullable
    private <E extends JpsElement> Element loadComponentData(@NotNull JpsElementExtensionSerializerBase<E> serializer, @NotNull Path configFile) {
        if (serializer == null) {
            JpsComponentLoader.$$$reportNull$$$0(8);
        }
        if (configFile == null) {
            JpsComponentLoader.$$$reportNull$$$0(9);
        }
        String componentName = serializer.getComponentName();
        Element component = this.loadComponent(configFile, componentName);
        if (!(serializer instanceof JpsProjectExtensionWithExternalDataSerializer) || this.myExternalConfigurationDirectory == null) {
            return component;
        }
        JpsProjectExtensionWithExternalDataSerializer externalDataSerializer = (JpsProjectExtensionWithExternalDataSerializer)serializer;
        Path externalConfigFile = this.myExternalConfigurationDirectory.resolve(externalDataSerializer.getExternalConfigFilePath());
        if (!Files.exists(externalConfigFile, new LinkOption[0])) {
            return component;
        }
        Element externalData = null;
        String externalComponentName = externalDataSerializer.getExternalComponentName();
        for (Element child : JDOMUtil.getChildren((Element)this.loadRootElement(externalConfigFile))) {
            if (!child.getName().equals(externalComponentName) && !JDomSerializationUtil.isComponent(externalComponentName, child) && !child.getName().equals(componentName) && !JDomSerializationUtil.isComponent(componentName, child)) continue;
            externalData = child;
            break;
        }
        if (externalData == null) {
            return component;
        }
        if (component == null) {
            return externalData;
        }
        externalDataSerializer.mergeExternalData(component, externalData);
        return component;
    }

    @Nullable
    static Element loadRootElement(@NotNull Path file, @NotNull JpsMacroExpander macroExpander) {
        Element element;
        if (file == null) {
            JpsComponentLoader.$$$reportNull$$$0(10);
        }
        if (macroExpander == null) {
            JpsComponentLoader.$$$reportNull$$$0(11);
        }
        if ((element = JpsComponentLoader.tryLoadRootElement(file)) != null) {
            macroExpander.substitute(element, SystemInfoRt.isFileSystemCaseSensitive);
        }
        return element;
    }

    @Nullable
    public static Element tryLoadRootElement(@NotNull Path file) {
        if (file == null) {
            JpsComponentLoader.$$$reportNull$$$0(12);
        }
        int i = 0;
        while (true) {
            try {
                return JDOMUtil.load((Path)file);
            }
            catch (NoSuchFileException e) {
                return null;
            }
            catch (IOException | JDOMException e) {
                if (++i == 5) {
                    throw new CannotLoadJpsModelException(file.toFile(), "Cannot " + (e instanceof IOException ? "read" : "parse") + " file " + file.toAbsolutePath() + ": " + e.getMessage(), e);
                }
                LOG.info("Loading attempt #" + i + " failed for " + file.toAbsolutePath(), e);
                try {
                    LOG.info("File content: " + FileUtilRt.loadFile((File)file.toFile()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException ignored) {
                    return null;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroExpander";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JpsComponentLoader";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultConfigFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsComponentLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacroExpander";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadRootElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadComponents";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadComponentData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadRootElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

