/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibCheckers;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDeclarationsChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDiagnosticContext;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibExportingDeclaration;
import org.jetbrains.kotlin.ir.backend.js.checkers.declarations.JsKlibEsModuleExportsChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.declarations.JsKlibOtherModuleExportsChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.expressions.JsKlibJsCodeCallChecker;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.library.SerializedIrFile;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f0\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibCheckers;", "", "<init>", "()V", "exportedDeclarationsCheckers", "", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDeclarationsChecker;", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration;", "callCheckers", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/expressions/JsKlibJsCodeCallChecker;", "makeChecker", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "cleanFiles", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "exportedNames", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "ir.serialization.js"})
public final class JsKlibCheckers {
    @NotNull
    public static final JsKlibCheckers INSTANCE = new JsKlibCheckers();
    @NotNull
    private static final List<JsKlibDeclarationsChecker<JsKlibExportingDeclaration>> exportedDeclarationsCheckers;
    @NotNull
    private static final List<JsKlibJsCodeCallChecker> callCheckers;

    private JsKlibCheckers() {
    }

    @NotNull
    public final IrVisitorVoid makeChecker(@NotNull List<SerializedIrFile> cleanFiles, @NotNull Map<IrFile, ? extends Map<IrDeclarationWithName, String>> exportedNames, @NotNull IrDiagnosticReporter diagnosticReporter, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter(cleanFiles, (String)"cleanFiles");
        Intrinsics.checkNotNullParameter(exportedNames, (String)"exportedNames");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return new IrVisitorVoid(configuration, cleanFiles, exportedNames, diagnosticReporter){
            private final JsKlibDiagnosticContext diagnosticContext;
            final /* synthetic */ List<SerializedIrFile> $cleanFiles;
            final /* synthetic */ Map<IrFile, Map<IrDeclarationWithName, String>> $exportedNames;
            final /* synthetic */ IrDiagnosticReporter $diagnosticReporter;
            {
                this.$cleanFiles = $cleanFiles;
                this.$exportedNames = $exportedNames;
                this.$diagnosticReporter = $diagnosticReporter;
                this.diagnosticContext = new JsKlibDiagnosticContext($configuration);
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof IrDeclaration) {
                    this.diagnosticContext.withDeclarationScope((IrDeclaration)element, (Function0<Unit>)((Function0)() -> makeChecker.1.visitElement$lambda$0(element, this)));
                } else {
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }
            }

            public void visitModuleFragment(IrModuleFragment declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                List<JsKlibExportingDeclaration> exportedDeclarations = JsKlibExportingDeclaration.Companion.collectDeclarations(this.$cleanFiles, declaration.getFiles(), this.$exportedNames);
                for (JsKlibDeclarationsChecker checker : JsKlibCheckers.access$getExportedDeclarationsCheckers$p()) {
                    checker.check(exportedDeclarations, this.diagnosticContext, this.$diagnosticReporter);
                }
                super.visitModuleFragment(declaration);
            }

            public void visitFile(IrFile declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.diagnosticContext.withFileScope(declaration, (Function0<Unit>)((Function0)() -> makeChecker.1.visitFile$lambda$1(this, declaration)));
            }

            public void visitCall(IrCall expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                for (JsKlibJsCodeCallChecker checker : JsKlibCheckers.access$getCallCheckers$p()) {
                    checker.check(expression, this.diagnosticContext, this.$diagnosticReporter);
                }
                super.visitCall(expression);
            }

            private static final Unit visitElement$lambda$0(IrElement $element, makeChecker.1 this$0) {
                IrVisitorsKt.acceptChildrenVoid($element, this$0);
                return Unit.INSTANCE;
            }

            private static final Unit visitFile$lambda$1(makeChecker.1 this$0, IrFile $declaration) {
                super.visitFile($declaration);
                return Unit.INSTANCE;
            }
        };
    }

    public static final /* synthetic */ List access$getExportedDeclarationsCheckers$p() {
        return exportedDeclarationsCheckers;
    }

    public static final /* synthetic */ List access$getCallCheckers$p() {
        return callCheckers;
    }

    static {
        Object[] objectArray = new JsKlibDeclarationsChecker[]{JsKlibEsModuleExportsChecker.INSTANCE, JsKlibOtherModuleExportsChecker.INSTANCE};
        exportedDeclarationsCheckers = CollectionsKt.listOf((Object[])objectArray);
        callCheckers = CollectionsKt.listOf((Object)JsKlibJsCodeCallChecker.INSTANCE);
    }
}

